import { Component, OnInit } from '@angular/core';
import { FormControl, Validators, FormGroup } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';
import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';

@Component({
  selector: 'app-create-category-dialog',
  templateUrl: './create-category-dialog.component.html',
  styleUrls: ['./create-category-dialog.component.scss']
})
export class CreateCategoryDialogComponent implements OnInit {
  public ButtonType = ButtonType;
  public textField = new FormControl('', [Validators.required, Validators.maxLength(500)]);
  public formGroup: FormGroup;

  constructor(public dialogRef: MatDialogRef<CreateCategoryDialogComponent>, private categoryFacade: CategoryFacadeService) {
    this.formGroup = new FormGroup({
      text: this.textField
    });
  }

  ngOnInit(): void {}

  submit(): void {
    this.categoryFacade.addNewCategory(this.textField.value);
    this.dialogRef.close();
  }
}
