﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Api.ApplicationServices.Questioning;
using FinkiChattery.Commands.Moderating;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Contracts.Moderating;
using FinkiChattery.Queries.Questioning;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/[controller]")]
    [ApiController]
    public class CategoriesController : ControllerBase
    {
        public CategoriesController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpGet]
        [Authorize]
        public async Task<IActionResult> GetCategories()
        {
            var categoriesList = await MediatorService.SendQueryAsync(new GetCategoriesQuery());
            return Ok(categoriesList.ToCategoryDtos());
        }

        [HttpPost]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Moderator)]
        public async Task<IActionResult> CreateNewCategory([FromBody] CreateCategoryRequest request)
        {
            var categoryUid = await MediatorService.SendAsync(new CreateCategoryCommand(request.Name));
            return Ok(categoryUid);
        }
    }
}
