﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Moderating
{
    public class CreateCategoryCommand : ICommand<Guid>
    {
        public CreateCategoryCommand(string categoryName)
        {
            CategoryName = categoryName;
        }

        public string CategoryName { get; }
    }

    public class CreateCategoryHandler : ICommandHandler<CreateCategoryCommand, Guid>
    {
        public CreateCategoryHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task<Guid> Handle(CreateCategoryCommand request, CancellationToken cancellationToken)
        {
            var category = new Category()
            {
                Name = request.CategoryName
            };

            UnitOfWork.Categories.Add(category);

            await UnitOfWork.SaveAsync();

            return category.Uid;
        }
    }
}
