﻿using FinkiChattery.Commands.Moderating.Validators;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Moderating
{
    public class CreateCategoryValidator : AbstractValidator<CreateCategoryCommand>
    {
        public CreateCategoryValidator(IUnitOfWork unitOfWork)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x.CategoryName).CategoryTitleValidate();
            RuleFor(x => x.CategoryName).SetValidator(new CategoryWithNameIsUnique(unitOfWork));
        }
    }
}
