﻿using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Moderating.Validators
{
    public class CategoryWithNameIsUnique : AsyncValidatorBase
    {
        public CategoryWithNameIsUnique(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var categoryName = (string)context.PropertyValue;

            return await UnitOfWork.Categories.CategoryWithNameIsUnique(categoryName);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return ModeratingErrorCodes.CategoryNameAlreadyExists;
        }
    }
}
