﻿using FluentValidation;

namespace FinkiChattery.Commands.Moderating.Validators
{
    public static class ModeratingFluentValidationRules
    {
        public static IRuleBuilderOptions<T, string> CategoryTitleValidate<T>(this IRuleBuilder<T, string> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(ModeratingErrorCodes.CantBeNull).MaximumLength(500).WithMessage(ModeratingErrorCodes.CategoryNameLengthInvalid);
        }
    }
}
