﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using System;

namespace FinkiChattery.Commands.Questioning
{
    public class AnswerVotedEvent : IEvent
    {
        public AnswerVotedEvent(Guid questionUid, Guid answerUid, Guid studentUid, VoteType voteType, bool voteAlreadyExists)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
            StudentUid = studentUid;
            VoteType = voteType;
            VoteAlreadyExists = voteAlreadyExists;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
        public Guid StudentUid { get; }
        public VoteType VoteType { get; }
        public bool VoteAlreadyExists { get; }
    }
}
