﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Contracts.Questioning;
using FinkiChattery.Persistence.Helpers;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/questions/{questionUid:Guid}/answers/{answerUid:Guid}/[controller]")]
    [ApiController]
    public class VotesController : ControllerBase
    {
        public VotesController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpPost]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> VoteAnswer([FromRoute] Guid questionUid, [FromRoute] Guid answerUid, [FromBody] VoteAnswerRequest request)
        {
            VoteType voteType = request.VoteType == VoteTypeRequest.Upvote ? VoteType.Upvote : VoteType.Downvote;
            var vote = await MediatorService.SendAsync(new VoteAnswerCommand(voteType, answerUid, questionUid));
            return Ok(new VoteAnswerResponse(answerUid, vote.VoteUid, request.VoteType, vote.VoteAlreadyExists));
        }
    }
}
