import * as moment from 'moment';

export class ApplicationUser {
  constructor(
    public id: number,
    public userType: ApplicationUserType,
    public email: string,
    public username: string,
    public isVerified: boolean
  ) {}
}

export enum ApplicationUserType {
  Student = 'Student',
  Teacher = 'Teacher',
  Moderator = 'Moderator',
  Guest = 'Guest'
}

export class SelfUserResponse {
  public student?: StudentSelfResponse | null;
  public teacher?: TeacherSelfResponse | null;
  public moderator?: ModeratorSelfResponse | null;
}

export class StudentSelfResponse {
  public uid!: string;
  public applicationUserId!: number;
  public index!: string;
  public reputation!: number;
  public imageUrl!: string;
  public questions!: StudentQuestionResponse[];
  public teams!: StudentTeamResponse[];
  public notifications!: StudentNotificationResponse[];
}

export class StudentNotificationResponse {
  public uid!: string;
  public createdOn!: moment.Moment;
  public questionUid!: string;
  public text!: string;

  constructor(uid: string, createdOn: moment.Moment, questionUid: string, text: string) {
    this.uid = uid;
    this.createdOn = createdOn;
    this.questionUid = questionUid;
    this.text = text;
  }
}

export class StudentQuestionResponse {
  public questionUid!: string;
  public title!: string;
}

export class StudentTeamResponse {
  public teamUid!: string;
  public name!: string;
}

export class ModeratorSelfResponse {
  public uid!: string;
  public applicationUserId!: number;
}

export class TeacherSelfResponse {
  public uid!: string;
  public applicationUserId!: number;
  public teams!: TeacherTeamResponse[];
}

export class TeacherTeamResponse {
  public teamUid!: string;
  public name!: string;
}
