import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FlexLayoutModule } from '@angular/flex-layout';

import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { TranslateModule } from '@ngx-translate/core';
import { NgxMaterialTimepickerModule } from 'ngx-material-timepicker';
import { FileUploadModule } from 'ng2-file-upload';
import { EditorModule } from '@tinymce/tinymce-angular';

import { COMPONENTS } from './components/components';
import { SharedMaterialModule } from '../shared-material/shared-material.module';
import { DIRECTIVES } from './directives/directives';
import { SERVICES } from './services/services';
import { PIPES } from './pipes/pipes';
import { NgPipesModule } from 'ngx-pipes';

@NgModule({
  declarations: [COMPONENTS, DIRECTIVES, PIPES],
  providers: [SERVICES],
  imports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    TranslateModule,
    SharedMaterialModule,
    FlexLayoutModule,
    FileUploadModule,
    NgxMaterialTimepickerModule,
    EditorModule,
    NgPipesModule
  ],
  exports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    TranslateModule,
    FlexLayoutModule,
    FileUploadModule,
    NgxMaterialTimepickerModule,
    COMPONENTS,
    DIRECTIVES,
    PIPES,
    SharedMaterialModule,
    EditorModule,
    NgPipesModule
  ]
})
export class SharedAppModule {}
