﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class NotifyStudentHisAnswerIsVoted : IEventHandler<AnswerVotedEvent>
    {
        public NotifyStudentHisAnswerIsVoted(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(AnswerVotedEvent notification, CancellationToken cancellationToken)
        {
            var student = await UnitOfWork.Students.GetByUidAsync(notification.StudentUid);
            var question = await UnitOfWork.Questions.GetByUidAsync(notification.QuestionUid);

            if (student == null)
            {
                return;
            }

            if (question == null)
            {
                return;
            }

            var studentNotification = new StudentNotification()
            {
                StudentFk = student.Id,
                QuestionUid = notification.QuestionUid,
                Text = $"Your answer has been voted on question {question.Title}"
            };

            UnitOfWork.StudentNotifications.Add(studentNotification);
            await UnitOfWork.SaveAsync();
        }
    }
}
