﻿using FinkiChattery.Contracts.User;
using FinkiChattery.Queries.User;
using System.Linq;

namespace FinkiChattery.Api.ApplicationServices.User
{
    public static class SelfUserMapper
    {
        public static SelfUserResponse ToSelfUserResponse(this SelfUserDto dto)
        {
            if (dto.StudentSelf != null)
            {
                var student = new StudentSelfResponse(dto.StudentSelf.Uid,
                                                      dto.StudentSelf.ApplicationUserId,
                                                      dto.StudentSelf.Index,
                                                      dto.StudentSelf.Reputation,
                                                      dto.StudentSelf.ImageUrl,
                                                      dto.StudentSelf.Questions.Select(x => new StudentQuestionResponse(x.QuestionUid, x.Title)),
                                                      dto.StudentSelf.Teams.Select(x => new StudentTeamResponse(x.TeamUid, x.Name)),
                                                      dto.StudentSelf.Notifications.Select(x => new StudentNotificationResponse(x.Uid, x.Text, x.CreatedOn, x.QuestionUid)));

                return new SelfUserResponse(student);
            }

            if (dto.TeacherSelf != null)
            {
                var teacher = new TeacherSelfResponse(dto.TeacherSelf.Uid, dto.TeacherSelf.ApplicationUserId, dto.TeacherSelf.Teams.Select(x => new TeacherTeamResponse(x.TeamUid, x.Name)));

                return new SelfUserResponse(null, teacher);
            }

            if (dto.ModeratorSelf != null)
            {
                var moderator = new ModeratorSelfResponse(dto.ModeratorSelf.Uid, dto.ModeratorSelf.ApplicationUserId);

                return new SelfUserResponse(null, null, moderator);
            }

            return new SelfUserResponse();
        }
    }
}
