﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Notifications
{
    public class StudentCheckedNotificationsCommand : ICommand<Unit>
    {
        public StudentCheckedNotificationsCommand()
        {
        }
    }

    public class StudentCheckedNotificationsHandler : ICommandHandler<StudentCheckedNotificationsCommand, Unit>
    {
        public StudentCheckedNotificationsHandler(ICurrentUser currentUser, IUnitOfWork unitOfWork)
        {
            CurrentUser = currentUser;
            UnitOfWork = unitOfWork;
        }

        public ICurrentUser CurrentUser { get; }
        public IUnitOfWork UnitOfWork { get; }

        public async Task<Unit> Handle(StudentCheckedNotificationsCommand request, CancellationToken cancellationToken)
        {
            var student = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            student.LastCheckedNotifications = System.DateTime.UtcNow;

            await UnitOfWork.SaveAsync();

            return Unit.Value;
        }
    }
}
