﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace FinkiChattery.Persistence.Repositories.Contracts
{
    public class StudentSelfDto
    {
        public StudentSelfDto(Guid uid, long applicationUserId, string index, long reputation, string imageUrl, DateTime lastCheckedNotifications, IEnumerable<StudentQuestionDto> questions, IEnumerable<StudentTeamDto> teams, IEnumerable<StudentSelfNotificationDto> notifications = null)
        {
            Uid = uid;
            ApplicationUserId = applicationUserId;
            Index = index;
            Reputation = reputation;
            ImageUrl = imageUrl;
            LastCheckedNotifications = lastCheckedNotifications;
            Questions = questions;
            Teams = teams;
            Notifications = notifications;
        }

        public Guid Uid { get; }
        public long ApplicationUserId { get; }
        public string Index { get; }
        public long Reputation { get; }
        public string ImageUrl { get; }
        public DateTime LastCheckedNotifications { get; }
        public IEnumerable<StudentQuestionDto> Questions { get; }
        public IEnumerable<StudentTeamDto> Teams { get; }
        public IEnumerable<StudentSelfNotificationDto> Notifications { get; set; }
    }
}
