/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config.provider;

import io.sentry.config.provider.ConfigurationProvider;
import io.sentry.util.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentConfigurationProvider
implements ConfigurationProvider {
    public static final String DEFAULT_ENV_VAR_PREFIX = "SENTRY_";
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentConfigurationProvider.class);
    private final String prefix;

    public EnvironmentConfigurationProvider() {
        this(DEFAULT_ENV_VAR_PREFIX);
    }

    public EnvironmentConfigurationProvider(String envVarPrefix) {
        this.prefix = envVarPrefix;
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        String ret = System.getenv(this.prefix + key.replace(".", "_").toUpperCase());
        if (ret != null) {
            logger.debug("Found {}={} in System Environment Variables.", (Object)key, (Object)ret);
        }
        return ret;
    }
}

