/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event.helper;

import io.sentry.event.helper.BasicRemoteAddressResolver;
import io.sentry.event.helper.RemoteAddressResolver;
import io.sentry.util.Util;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ForwardedAddressResolver
implements RemoteAddressResolver {
    private BasicRemoteAddressResolver basicRemoteAddressResolver = new BasicRemoteAddressResolver();

    private static String firstAddress(String csvAddrs) {
        List<String> ips = Arrays.asList(csvAddrs.split(","));
        return ips.get(0).trim();
    }

    @Override
    public String getRemoteAddress(HttpServletRequest request) {
        String forwarded = request.getHeader("X-FORWARDED-FOR");
        if (!Util.isNullOrEmpty(forwarded)) {
            return ForwardedAddressResolver.firstAddress(forwarded);
        }
        return this.basicRemoteAddressResolver.getRemoteAddress(request);
    }
}

