/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event.interfaces;

import io.sentry.event.interfaces.ExceptionMechanism;
import io.sentry.event.interfaces.ExceptionMechanismThrowable;
import io.sentry.event.interfaces.StackTraceInterface;
import io.sentry.jvmti.FrameCache;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;

public final class SentryException
implements Serializable {
    public static final String DEFAULT_PACKAGE_NAME = "(default)";
    private final String exceptionMessage;
    private final String exceptionClassName;
    private final String exceptionPackageName;
    private final StackTraceInterface stackTraceInterface;
    private final ExceptionMechanism exceptionMechanism;

    public SentryException(Throwable throwable, StackTraceElement[] childExceptionStackTrace) {
        this(throwable, childExceptionStackTrace, null);
    }

    public SentryException(Throwable throwable, StackTraceElement[] childExceptionStackTrace, ExceptionMechanism exceptionMechanism) {
        Package exceptionPackage = throwable.getClass().getPackage();
        String fullClassName = throwable.getClass().getName();
        this.exceptionMessage = throwable.getMessage();
        this.exceptionClassName = exceptionPackage != null ? fullClassName.replace(exceptionPackage.getName() + ".", "") : fullClassName;
        this.exceptionPackageName = exceptionPackage != null ? exceptionPackage.getName() : null;
        this.stackTraceInterface = new StackTraceInterface(throwable.getStackTrace(), childExceptionStackTrace, FrameCache.get(throwable));
        this.exceptionMechanism = exceptionMechanism;
    }

    public SentryException(String exceptionMessage, String exceptionClassName, String exceptionPackageName, StackTraceInterface stackTraceInterface) {
        this(exceptionMessage, exceptionClassName, exceptionPackageName, stackTraceInterface, null);
    }

    public SentryException(String exceptionMessage, String exceptionClassName, String exceptionPackageName, StackTraceInterface stackTraceInterface, ExceptionMechanism exceptionMechanism) {
        this.exceptionMessage = exceptionMessage;
        this.exceptionClassName = exceptionClassName;
        this.exceptionPackageName = exceptionPackageName;
        this.stackTraceInterface = stackTraceInterface;
        this.exceptionMechanism = exceptionMechanism;
    }

    public static Deque<SentryException> extractExceptionQueue(Throwable throwable) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<Throwable> circularityDetector = new HashSet<Throwable>();
        StackTraceElement[] childExceptionStackTrace = new StackTraceElement[]{};
        ExceptionMechanism exceptionMechanism = null;
        while (throwable != null && circularityDetector.add(throwable)) {
            if (throwable instanceof ExceptionMechanismThrowable) {
                ExceptionMechanismThrowable exceptionMechanismThrowable = (ExceptionMechanismThrowable)throwable;
                exceptionMechanism = exceptionMechanismThrowable.getExceptionMechanism();
                throwable = exceptionMechanismThrowable.getThrowable();
            } else {
                exceptionMechanism = null;
            }
            exceptions.add(new SentryException(throwable, childExceptionStackTrace, exceptionMechanism));
            childExceptionStackTrace = throwable.getStackTrace();
            throwable = throwable.getCause();
        }
        return exceptions;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionPackageName() {
        return this.exceptionPackageName != null ? this.exceptionPackageName : DEFAULT_PACKAGE_NAME;
    }

    public StackTraceInterface getStackTraceInterface() {
        return this.stackTraceInterface;
    }

    public ExceptionMechanism getExceptionMechanism() {
        return this.exceptionMechanism;
    }

    public String toString() {
        return "SentryException{exceptionMessage='" + this.exceptionMessage + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionPackageName='" + this.exceptionPackageName + '\'' + ", exceptionMechanism='" + this.exceptionMechanism + '\'' + ", stackTraceInterface=" + this.stackTraceInterface + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryException that = (SentryException)o;
        if (!this.exceptionClassName.equals(that.exceptionClassName)) {
            return false;
        }
        if (this.exceptionMessage != null ? !this.exceptionMessage.equals(that.exceptionMessage) : that.exceptionMessage != null) {
            return false;
        }
        if (this.exceptionPackageName != null ? !this.exceptionPackageName.equals(that.exceptionPackageName) : that.exceptionPackageName != null) {
            return false;
        }
        if (this.exceptionMechanism != null ? !this.exceptionMechanism.equals(that.exceptionMechanism) : that.exceptionMechanism != null) {
            return false;
        }
        return this.stackTraceInterface.equals(that.stackTraceInterface);
    }

    public int hashCode() {
        int result = this.exceptionMessage != null ? this.exceptionMessage.hashCode() : 0;
        result = 31 * result + this.exceptionClassName.hashCode();
        result = 31 * result + (this.exceptionPackageName != null ? this.exceptionPackageName.hashCode() : 0);
        return result;
    }
}

