/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config;

import io.sentry.Sentry;
import io.sentry.config.CompoundResourceLoader;
import io.sentry.config.ContextClassLoaderResourceLoader;
import io.sentry.config.FileResourceLoader;
import io.sentry.config.ResourceLoader;
import io.sentry.config.location.CompoundResourceLocator;
import io.sentry.config.location.ConfigurationResourceLocator;
import io.sentry.config.location.EnvironmentBasedLocator;
import io.sentry.config.location.StaticFileLocator;
import io.sentry.config.location.SystemPropertiesBasedLocator;
import io.sentry.config.provider.CompoundConfigurationProvider;
import io.sentry.config.provider.ConfigurationProvider;
import io.sentry.config.provider.EnvironmentConfigurationProvider;
import io.sentry.config.provider.JndiConfigurationProvider;
import io.sentry.config.provider.JndiSupport;
import io.sentry.config.provider.LocatorBasedConfigurationProvider;
import io.sentry.config.provider.SystemPropertiesConfigurationProvider;
import io.sentry.dsn.Dsn;
import io.sentry.util.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Lookup {
    private static final Logger logger = LoggerFactory.getLogger(Lookup.class);
    private final ConfigurationProvider highPriorityProvider;
    private final ConfigurationProvider lowPriorityProvider;

    public Lookup(ConfigurationProvider highPriorityProvider, ConfigurationProvider lowPriorityProvider) {
        this.highPriorityProvider = highPriorityProvider;
        this.lowPriorityProvider = lowPriorityProvider;
    }

    public static Lookup getDefault() {
        return new Lookup(new CompoundConfigurationProvider(Lookup.getDefaultHighPriorityConfigurationProviders(Collections.emptyList())), new CompoundConfigurationProvider(Lookup.getDefaultLowPriorityConfigurationProviders(Collections.emptyList())));
    }

    public static Lookup getDefaultWithAdditionalProviders(Collection<ConfigurationProvider> highPriorityProviders, Collection<ConfigurationProvider> lowPriorityProviders) {
        return new Lookup(new CompoundConfigurationProvider(Lookup.getDefaultHighPriorityConfigurationProviders(highPriorityProviders)), new CompoundConfigurationProvider(Lookup.getDefaultLowPriorityConfigurationProviders(lowPriorityProviders)));
    }

    private static List<ConfigurationResourceLocator> getDefaultResourceLocators() {
        return Arrays.asList(new SystemPropertiesBasedLocator(), new EnvironmentBasedLocator(), new StaticFileLocator());
    }

    private static List<ConfigurationProvider> getDefaultHighPriorityConfigurationProviders(Collection<ConfigurationProvider> additionalProviders) {
        boolean jndiPresent = JndiSupport.isAvailable();
        int providersCount = jndiPresent ? 3 + additionalProviders.size() : 2 + additionalProviders.size();
        ArrayList<ConfigurationProvider> providers = new ArrayList<ConfigurationProvider>(providersCount);
        providers.addAll(additionalProviders);
        if (jndiPresent) {
            providers.add(new JndiConfigurationProvider());
        }
        providers.add(new SystemPropertiesConfigurationProvider());
        providers.add(new EnvironmentConfigurationProvider());
        return providers;
    }

    private static List<ResourceLoader> getDefaultResourceLoaders() {
        ResourceLoader sentryLoader = Sentry.getResourceLoader();
        return sentryLoader == null ? Arrays.asList(new FileResourceLoader(), new ContextClassLoaderResourceLoader()) : Arrays.asList(new FileResourceLoader(), sentryLoader, new ContextClassLoaderResourceLoader());
    }

    private static List<ConfigurationProvider> getDefaultLowPriorityConfigurationProviders(Collection<ConfigurationProvider> additionalProviders) {
        ArrayList<ConfigurationProvider> providers = new ArrayList<ConfigurationProvider>(additionalProviders.size());
        providers.addAll(additionalProviders);
        try {
            providers.add(new LocatorBasedConfigurationProvider((ResourceLoader)new CompoundResourceLoader(Lookup.getDefaultResourceLoaders()), new CompoundResourceLocator(Lookup.getDefaultResourceLocators()), Charset.defaultCharset()));
        }
        catch (IOException e) {
            logger.debug("Failed to instantiate resource locator-based configuration provider.", (Throwable)e);
        }
        return providers;
    }

    @Deprecated
    public static String lookup(String key) {
        return Lookup.lookup(key, null);
    }

    @Deprecated
    public static String lookup(String key, Dsn dsn) {
        return Lookup.getDefault().get(key, dsn);
    }

    @Nullable
    public String get(String key) {
        return this.get(key, null);
    }

    @Nullable
    public String get(String key, @Nullable Dsn dsn) {
        String val = this.highPriorityProvider.getProperty(key);
        if (val == null && dsn != null && (val = dsn.getOptions().get(key)) != null) {
            logger.debug("Found {}={} in DSN.", (Object)key, (Object)val);
        }
        if (val == null) {
            val = this.lowPriorityProvider.getProperty(key);
        }
        return val == null ? null : val.trim();
    }
}

