/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static Map<String, String> parseCsv(String inputString, String typeName) {
        if (Util.isNullOrEmpty(inputString)) {
            return Collections.emptyMap();
        }
        String[] entries = inputString.split(",");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String entry : entries) {
            String[] split = entry.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid " + typeName + " entry: " + entry);
            }
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static Map<String, String> parseTags(String tagsString) {
        return Util.parseCsv(tagsString, "tags");
    }

    public static Map<String, String> parseExtra(String extrasString) {
        return Util.parseCsv(extrasString, "extras");
    }

    @Deprecated
    public static Set<String> parseExtraTags(String extraTagsString) {
        return Util.parseMdcTags(extraTagsString);
    }

    public static Set<String> parseMdcTags(String mdcTagsString) {
        if (Util.isNullOrEmpty(mdcTagsString)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(mdcTagsString.split(",")));
    }

    public static Integer parseInteger(String value, Integer defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Long parseLong(String value, Long defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static Double parseDouble(String value, Double defaultValue) {
        if (Util.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static String trimString(String string, int maxMessageLength) {
        if (string == null) {
            return null;
        }
        if (string.length() > maxMessageLength) {
            return string.substring(0, maxMessageLength - 3) + "...";
        }
        return string;
    }

    public static boolean safelyRemoveShutdownHook(Thread shutDownHook) {
        try {
            return Runtime.getRuntime().removeShutdownHook(shutDownHook);
        }
        catch (IllegalStateException e) {
            if (!e.getMessage().equals("Shutdown in progress")) {
                throw e;
            }
            return false;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
    }
}

