-- DROP SCHEMA "Project";

CREATE SCHEMA "Project" AUTHORIZATION db_202122z_va_prj_freeparkingspace_owner;

create table Najava(
Korisnicko_ime varchar(150) primary key,
EMBG char(13) not null,
Br_tel varchar(30) not null,
Email varchar(150) not null,
password varchar(50) not null,
Ime varchar(150) not null,
Prezime varchar(150) not null
);

create table Vraboten(
Id_vraboten serial not null,
Uloga varchar(50) not null,
Korisnicko_ime varchar(150) primary key,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Najava (Korisnicko_ime)
);

create table Administrator (
Id_administrator serial not null,
Korisnicko_ime varchar(150) primary key,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Najava (Korisnicko_ime)
);

create table Kontroler (
Id_kontroler serial not null,
Korisnicko_ime varchar(150) primary key,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Najava (Korisnicko_ime)
);

create table Kancelar (
Id_kancelar serial not null,
Korisnicko_ime varchar(150) primary key,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Najava (Korisnicko_ime)
);

create table  Ime_na_parking (
Id_ime integer primary key,
Lokacija varchar(150) not null,
Administrator_Korisnicko_ime varchar(150) not null,

constraint fk_Administrator_Korisnicko_ime foreign key (Administrator_Korisnicko_ime) references Administrator (Korisnicko_ime)
);

create table Zona (
Id_zona varchar (20) primary key,
Ime_na_parking_Id_Ime integer not null,

constraint fk_Ime_na_parking foreign key (Ime_na_parking_Id_Ime) references Ime_na_parking (Id_ime)
);

create table Parking_mesto (
Broj_na_pmesta integer primary key,
IdZona varchar(20) not null,

constraint fk_IdZona foreign key (IdZona) references Zona (Id_zona)
);

create table Korisnik(
Id_korisnik serial  not null,
Korisnicko_ime varchar(150) primary key,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Najava (Korisnicko_ime)
);

create table Avtomobil(
Reg_tablica varchar(10) primary key,
Marka varchar(20) not null,
Boja varchar (15),
Korisnickoime varchar(150) not null,

constraint fk_Korisnickoime foreign key (Korisnickoime) references Korisnik (Korisnicko_ime)
);


create table Plakjanje (
Id_plakanje integer primary key,
Korisnickoime varchar(150) not null,
Br_tel varchar(30),
Br_na_smetka varchar(150),
Tip_plakjanje varchar(150) not null,

constraint fk_Korisnickoime foreign key (Korisnickoime) references Korisnik (Korisnicko_ime),
constraint ck_tip_plakjanje check (case when tip_plakjanje='mobilno' then Br_tel!= 'not null' when tip_plakjanje='karticka' then Br_na_smetka!= 'not null' end)
);


create table Kazna (
Id_kazna integer primary key,
iznos integer not null,
broj_kazni integer not null,
Korisnickoime varchar(150) not null,

constraint fk_Korisnickoime foreign key (Korisnickoime) references Korisnik (Korisnicko_ime)

);

create table Rezervacija (

Id_rezervacija integer primary key,
pocetno_vreme TIMESTAMP not null,
krajno_vreme TIMESTAMP not null,
Reg_tablica varchar(10) not null,
Broj_na_pmesta integer not  null,
Id_plakanje integer not null ,

constraint fk_Reg_tablica foreign key (Reg_tablica) references Avtomobil (Reg_tablica),
constraint fk_Broj_na_pmesta foreign key (Broj_na_pmesta) references Parking_mesto (Broj_na_pmesta),
constraint fk_Id_plakanje foreign key (Id_plakanje) references Plakjanje (Id_plakanje)
);

create table Kontrola (
Id_kontrola serial primary key,
izvrsena_kontrola integer not null,
vreme_na_kontrola TIMESTAMP not null,
konstantacija varchar(300) not null,
Korisnicko_ime varchar(150) not null,
Broj_na_pmesta integer not  null,
Id_rezervacija integer not null,
Id_kazna integer not null,

constraint fk_Korisnicko_ime foreign key (Korisnicko_ime) references Kontroler (Korisnicko_ime),
constraint fk_Broj_na_pmesta foreign key (Broj_na_pmesta) references Parking_mesto (Broj_na_pmesta),
constraint fk_Id_rezervacija foreign key (Id_rezervacija) references Rezervacija (Id_rezervacija),
constraint fk_Id_kazna foreign key (Id_kazna) references Kazna (Id_kazna)
);