<?php

    session_start();

    require './connect.php';

    $products_list = mysqli_query($conn, "SELECT * FROM products ORDER BY discount DESC LIMIT 10;");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Home</title>

    <!-- Icons -->
    <link rel="stylesheet"
  href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">

    <link rel="stylesheet" href="./CSS/Header.css">
    <link rel="stylesheet" href="./CSS/Home.css">
</head>
<body>

    <?php include './components/Header.html' ?>

    <!-- SLIDER -->
    <section class="main-home">
        <div class="list">
            <div class="item" style="background-image: url(image/Samsung5.jpg)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>Samsung Odyssey</h1>
                    <p>Гејминг монитор дизајниран за најдобро визуелно искуство. Со извонредна резолуција, брзо освежување и време на одговор, овој монитор овозможува ултра-гладка и реалистична графика. Кривината на екранот и напредната технологија за синхронизација го прават идеален за интензивен гејминг и мултимедијална употреба. Samsung Odyssey е совршен избор за гејмери кои бараат квалитет и перформанси.</p>
                    <div class="btn">
                        <a href="./Product.php?product_id=107" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                    </div>

                </div>
            </div>
            <div class="item" style="background-image: url(image/RazerHunt.webp)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>Razer Huntsman V3 Pro</h1>
                    <p>Врвна гејминг тастатура со Razer оптички прекинувачи за ултрабрза реакција. Со RGB осветлување прилагодливо преку Razer Chroma и издржлив дизајн, оваа тастатура нуди импресивно гејминг искуство и удобност за долги сесии. Совршена за професионалци и аматери.</p>
                    <div class="btn">
                    <a href="./Product.php?product_id=129" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                </div>
                </div>
            </div>
            <div class="item" style="background-image: url(image/Razer4.png)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>Razer Viper V3 Pro</h1>
                    <p>Висококвалитетен гејминг глушец со Razer оптички сензор за прецизно следење и брзи реакции. Дизајниран е за максимална удобност и леснотија, со ергономска форма и лесна тежина. </p>
                    <div class="btn">
                    <a href="./Product.php?product_id=128" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                </div>
                </div>
            </div>
            <div class="item" style="background-image: url(image/RTX4090.jpg)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>GeForce RTX 4090</h1>
                    <p>Графичка картичка со најнова архитектура, нудејќи неверојатна графичка моќ и перформанси. Со 24GB GDDR6X меморија, поддршка за Ray Tracing и DLSS, оваа картичка е идеална за гејминг на највисоко ниво и професионални графички задачи. Овозможува ултра-гладок фрејмрејт и реалистични визуелни ефекти, правејќи ја совршен избор за најпребирливите корисници.</p>
                    <div class="btn">
                    <a href="./Product.php?product_id=121" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                </div>
                </div>
            </div>
            <div class="item" style="background-image: url(image/Woot2.jpg)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>Wooting 60 HE+</h1>
                    <p>Иновативна механичка тастатура со аналогни оптички прекинувачи, овозможувајќи прецизна контрола и уникатно гејминг искуство. Компактниот 60% дизајн ја прави идеална за минималистички сетапи, додека RGB осветлувањето со прилагодување додава стил и персонализација. Совршена за гејмери и професионалци кои бараат врвни перформанси и удобност.</p>
                    <div class="btn">
                    <a href="./Product.php?product_id=127" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                </div>
                </div>
            </div>
            <div class="item" style="background-image: url(image/RTX2.webp)">
                <div class="content">
                    <h5>Нови изданија</h5>
                    <h1>Radeon RX 7900</h1>
                    <p>Mоќна графичка картичка со најнова RDNA 3 архитектура, нудејќи врвни перформанси и неверојатна графика. Со голема количина на меморија и поддршка за најновите технологии, оваа картичка е идеална за гејминг, 3D рендерирање и професионални графички задачи. Овозможува висока резолуција, брзина и реалистични визуелни ефекти, правејќи ја одличен избор за сите кои бараат најдоброто.</p>
                    <div class="btn">
                    <a href="./Product.php?product_id=122" class="main-button">Купете сега! <i class='bx bx-right-arrow-alt' ></i></a> 
                </div>
                </div>
            </div>
        </div>

        <div class="arrow">
            <button class="prev"><</button>
            <button class="next">></button>
        </div>
        <div class="timeRunning"></div>
    </section>
    <!-- SLIDER -->

    <!-- Proizvodi na popust  -->
    <section class="discounted-products" id="discounted">
        <div class="center-text">
            <h2>Производи на <span>Попуст</span></h2>
        </div>

        <div class="products">
            <?php
                foreach($products_list as $product) {
                    if($product['image1'] != null) {
                        $image = basename(strrchr($product['image1'], '/'));
                        $image = str_replace(array("'"), '', $image);
                    }
                    ?>
                        <div class="row">
                            <img src="./UPLOADED_IMAGES/<?php echo $image ?>" style="width: 256px; height: 192px; object-fit:cover;">
                            <div class="product-text">
                                <h5><?php echo $product['discount'] ?>% ПОПУСТ!</h5>
                            </div>
                            
                            <div class="price">
                                <h4><a href="./Product.php?product_id=<?php echo $product['product_id'] ?>"><?php echo $product['name'] ?></a></h4>
                                <p><?php echo ($product['price'])-($product['price']*$product['discount']/100.0) ?>$</p>
                            </div>
                        </div>
                    <?php
                }
            ?>

        </div>
    </section>
    <!-- Proizvodi na popust  -->

    <!-- СИГУРНОСТ и FAQS -->
    <section class="FAQS">
        <div class="garancija">
            <h2>Гаранција</h2>
            <p>Сите наши производи доаѓаат со официјална гаранција обезбедена од производителот. Гаранциите ги покриваат дефектите во материјалите и изработката, овозможувајќи ви безгрижно користење на вашите производи. Доколку имате било какви проблеми со производот во текот на гаранцискиот период, ве молиме контактирајте не за да го решиме вашиот проблем брзо и ефикасно.</p>
        </div>

        <div class="FAQS-class">
            <h2>FAQS</h2>
            <h3>Кога ќе ја добијам мојата нарачка?</h3>
            <p>Времето на испорака зависи од локацијата и достапноста на производите. Обично, испораката трае од 3 до 7 работни дена. За точен период на испорака, проверете ја информацијата за испорака при нарачката.</p>
            <h3>Што да направам ако мојот производ пристигне оштетен?</h3>
            <p>Ако производот е оштетен при испорака, ве молиме контактирајте нас веднаш со фотографии од оштетената стока и пакувањето. Ќе организираме замена или враќање на производот што е можно поскоро.</p>
            <h3>Како да ја променам или откажам мојата нарачка?</h3>
            <p>За да ја промените или откажете вашата нарачка, контактирајте го нашиот тим за поддршка што е можно побрзо. Промените можат да се направат само ако нарачката не е веќе испратена.</p>
        </div>
    </section>


    <!-- Footer -->
     <section class="footer-class">
        <div class="footer-div">
            <div class="info-footer-first">
                <img src="image/NewLogo.png">
                <p>бул. АСНОМ 14 <br> Скопје, Македонија</p>
                <p>+389 71 111 222</p>
                <p>innovabuisness@gmail.com</p>
            </div>

            <div class="info-footer-second">
                <h4>Помош</h4>
                <p><a href="./Information/Contact.html">Контакт</a></p>
                <p><a href="./Information/AboutUs.html">За нас</a></p>
                <p><a href="./Information/Privacy.html">Политика на приватност</a></p>
            </div>

            <div class="info-footer-third">
                <h4>Customers</h4>
                <p>Гаранција</p>
                <p>Студенски дискоунт</p>
                <p>Return policy</p>
            </div>
        </div>
     </section>
     <!-- СИГУРНОСТ и FAQS -->

     <div class="end">
        <p>©2024 Innova. All rights reserved</p>
     </div>


     <script src="HomeSlider.js"></script>
</body>
</html>