<?php

    session_start();

    require "./connect.php";
    

    $category = htmlspecialchars($_GET["category"] ?? '');
    $price_sort = htmlspecialchars($_GET['price-sort'] ?? '');
    $unique_brands = null;

    if(isset($_GET['submit']) && isset($_GET['product_id'])) {

        if(!isset($_SESSION['user_ID'])) {
            header("Location: ./Log In.php");
        }
        
        if($_GET['submit'] == 'add-to-wishlist') {

            $check = mysqli_query($conn, "SELECT * FROM wishlist WHERE user_id={$_SESSION['user_ID']} AND product_id = {$_GET['product_id']};");

            try {
                if(mysqli_num_rows($check) <= 0) {
                    $res = mysqli_query($conn, "INSERT INTO wishlist(user_id, product_id) VALUES ({$_SESSION['user_ID']}, {$_GET['product_id']});");
                }
            } catch(Exception $e) {
                echo $e;
            }

            header("Location: ./Wishlist.php");
        }
        else if($_GET['submit'] == 'add-to-cart') {

            // proveri dali veke postoi
            $check = mysqli_query($conn, "SELECT * FROM cart WHERE user_id={$_SESSION['user_ID']} AND product_id = {$_GET['product_id']};");
            $quantity = 1;

            if(isset($_GET['quantity'])) {
                $quantity = $_GET['quantity'];
            }

            try {
                if(mysqli_num_rows($check) >= 1) {
                    mysqli_query($conn, "UPDATE cart SET quantity = {$quantity} WHERE id = {$check->fetch_assoc()['id']};");
                }
                else {
                    $res = mysqli_query($conn, "INSERT INTO cart(user_id, product_id, quantity) VALUES ({$_SESSION['user_ID']}, {$_GET['product_id']}, {$quantity});");
                }
            } catch(Exception $e) {
                
            }

            header("Location: ./Cart.php");
        }

        die();
    }

    if(empty($category)) {
        $category = 'All';
    }

    if(empty($price_sort) || ($price_sort != 'low-to-high' && $price_sort != 'high-to-low' && $price_sort != 'none')) {
        $price_sort = 'none';
    }

    if($category != 'All' && $category != 'Monitor' && $category != 'CPU' && $category != 'GPU'
        && $category != 'PSU' && $category != 'Motherboards' && $category != 'Cases'
        && $category != 'Storage' && $category != 'Peripherals') 
    {
        $category = 'All';
    }

    if($category == 'All') {
        $unique_brands = mysqli_query($conn, "SELECT DISTINCT brand FROM products;");
    }
    else {
        $unique_brands = mysqli_query($conn, "SELECT DISTINCT brand FROM products WHERE category = \"{$category}\";");
    }
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products</title>
    <link rel="stylesheet" href="../CSS/Header.css">
    <link rel="stylesheet" href="../CSS/Products.css">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
</head>
<body>

    <?php include './components/Header.html' ?>

    <section>
        <div class="container">
            <form class="sidebar" action="./Products.php" method="GET">
                <h1>Products</h1>
                <h5>Category</h5>
                <select id="selectCategory" name="category">
                    <option value="All" <?php if($category == "All") echo "selected"; ?> >All</option>
                    <option value="Monitor" <?php if($category == "Monitor") echo "selected"; ?> >Monitors</option>
                    <option value="CPU" <?php if($category == "CPU") echo "selected"; ?> >Processors</option>
                    <option value="GPU" <?php if($category == "GPU") echo "selected"; ?> >Graphics Cards</option>
                    <option value="PSU" <?php if($category == "PSU") echo "selected"; ?> >Power Supplies</option>
                    <option value="Motherboards" <?php if($category == "Motherboards") echo "selected"; ?> >Motherboards</option>
                    <option value="Storage" <?php if($category == "Storage") echo "selected"; ?> >Storage</option>
                    <option value="Peripherals" <?php if($category == "Peripherals") echo "selected"; ?> >Peripherals</option>
                    <option value="Cases" <?php if($category == "Cases") echo "selected"; ?> >Cases</option>
                </select>

                <h5>Sort By</h5>
                <label for="sortPrice">Price</label>
                <select id="sortPrice" name="price-sort">
                    <option value="none" <?php if($price_sort == 'none') echo "selected" ?> >None</option>
                    <option value="low-to-high" <?php if($price_sort == 'low-to-high') echo "selected" ?> >Low to High</option>
                    <option value="high-to-low" <?php if($price_sort == 'high-to-low') echo "selected" ?> >High to Low</option>
                </select>

                <h5>Filter By Brand</h5>
                <div class="checkbox-group">
                    <?php
                        $valid_brands = [];

                        if(mysqli_num_rows($unique_brands) >= 1) {
                            foreach($unique_brands as $brand_list){
                                $checked_brand = [];
                                
                                if(empty($brand_list['brand'])) {
                                    continue;
                                }

                                if(isset($_GET['brands'])) {
                                    $checked_brand = $_GET['brands'];

                                    if(in_array($brand_list['brand'], $checked_brand)) {
                                        $valid_brands[] = $brand_list['brand'];
                                    }
                                }
                                ?>
                                <div>
                                    <input type="checkbox" name="brands[]" value="<?php echo $brand_list['brand'] ?>" <?php if(in_array($brand_list['brand'], $checked_brand)) echo "checked"; ?> >
                                    <label><?php echo $brand_list['brand'] ?></label>
                                </div>

                                <?php
                            }
                        }
                    ?>
                </div>

                <input type="submit" value="Filter" id="filter-search-button">
            </form>

            <div class="main-content">
                <div class="products">
                    <?php
                        $all_products = null;

                        if(isset($_GET['brands'])) {

                            $brand_parameter = implode(',', $valid_brands);
                            $brand_parameter = explode(",", $brand_parameter);
                            $brand_parameter = "'".implode("','", $brand_parameter)."'";

                            if($category != 'All') {
                                if($price_sort == 'low-to-high' && count($valid_brands) >= 1) {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" AND brand IN ({$brand_parameter})
                                        ORDER BY (price - (price*discount/100.0)) ASC;
                                    ");
                                }
                                else if($price_sort == 'low-to-high' && count($valid_brands) <= 0) {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" ORDER BY (price - (price*discount/100.0)) ASC;");
                                }
                                else if($price_sort == 'high-to-low' && count($valid_brands) >= 1) {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" AND brand IN ({$brand_parameter})
                                        ORDER BY (price - (price*discount/100.0)) DESC;
                                    ");
                                }
                                else if($price_sort == 'high-to-low' && count($valid_brands) <= 0) {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" ORDER BY (price - (price*discount/100.0)) DESC;");
                                }
                                else if(count($valid_brands) >= 1) {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" AND brand IN ({$brand_parameter})
                                    ;");
                                }
                                else {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\";");
                                }
                            }
                            else {
                                if($price_sort == 'low-to-high') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE brand IN ({$brand_parameter})
                                        ORDER BY (price - (price*discount/100.0)) ASC;
                                    ");
                                }
                                else if($price_sort == 'high-to-low') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE brand IN ({$brand_parameter})
                                        ORDER BY (price - (price*discount/100.0)) DESC;
                                    ");
                                }
                                else {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE brand IN ({$brand_parameter})
                                    ;");
                                }
                            }

                            if(mysqli_num_rows($all_products) >= 1) {
                                foreach($all_products as $product) {
                                    ?>
                                        <div class="row">
                                            <div class="image-container">
                                                <img src="
                                                    <?php 
                                                        $product_image = basename(strrchr($product['image1'], '/'));
                                                        $product_image = str_replace(array("'"), '', $product_image);
                                                        echo 'UPLOADED_IMAGES/'.$product_image;
                                                    ?>
                                                ">
                                            </div>
                                            <div class="product-name">
                                                <a href="./Product.php?product_id=<?php echo $product['product_id'] ?>">
                                                    <?php echo $product['name']; ?>
                                                </a>
                                            </div>
                                            <div class="product-price">
                                                $
                                                <?php
                                                    $discount = $product['price'] * ($product['discount'] / 100);
                                                    echo $product['price'] - $discount; 
                                                ?>
                                            </div>
                                            <form class="icons-container" action="./Products.php" method="GET">
                                                <input type="hidden" name="product_id" value="<?php echo $product['product_id'] ?>">
                                                <button type="submit" name="submit" value="add-to-cart" style="border: none; font-size: 1.0em; background: transparent;" class='bx bx-cart'></button>
                                                <button type="submit" name="submit" value="add-to-wishlist" style="border: none; font-size: 1.0em; background: transparent;" class='bx bx-heart'></button>
                                            </form>
                                        </div>
                                    <?php
                                }
                            }
                            else {
                                echo '<p>No products</p>';
                            }
                        }
                        else {

                            if($category != 'All') {
                                if($price_sort == 'low-to-high') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" ORDER BY (price - (price*discount/100.0)) ASC;");
                                }
                                else if($price_sort == 'high-to-low') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\" ORDER BY (price - (price*discount/100.0)) DESC;");
                                }
                                else {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products WHERE category = \"$category\";");
                                }
                            }
                            else {
                                if($price_sort == 'low-to-high') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products ORDER BY (price - (price*discount/100.0)) ASC;");
                                }
                                else if($price_sort == 'high-to-low') {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products ORDER BY (price - (price*discount/100.0)) DESC;");
                                }
                                else {
                                    $all_products = mysqli_query($conn, "SELECT * FROM products;");
                                }
                            }

                            if(mysqli_num_rows($all_products) >= 1) {
                                foreach($all_products as $product) {
                                    ?>
                                        <div class="row">
                                            <div class="image-container">
                                                <img src="
                                                    <?php 
                                                        $product_image = basename(strrchr($product['image1'], '/'));
                                                        $product_image = str_replace(array("'"), '', $product_image);
                                                        echo 'UPLOADED_IMAGES/'.$product_image;
                                                    ?>
                                                ">
                                            </div>
                                            <div class="product-name">
                                                <a href="./Product.php?product_id=<?php echo $product['product_id'] ?>">
                                                    <?php echo $product['name']; ?>
                                                </a>
                                            </div>
                                            <div class="product-price">
                                                $
                                                <?php
                                                    $discount = $product['price'] * ($product['discount'] / 100);
                                                        echo $product['price'] - $discount; 
                                                ?>
                                            </div>
                                            <form class="icons-container" action="./Products.php" method="GET">
                                                <input type="hidden" name="product_id" value="<?php echo $product['product_id'] ?>">
                                                <button type="submit" name="submit" value="add-to-cart" style="border: none; font-size: 1.0em; background: transparent;" class='bx bx-cart'></button>
                                                <button type="submit" name="submit" value="add-to-wishlist" style="border: none; font-size: 1.0em; background: transparent;" class='bx bx-heart'></button>
                                            </form>
                                        </div>
                                    <?php
                                }
                            }
                            else {
                                echo '<p>No products</p>';
                            }
                        }
                    ?>
        </div>
    </section>
</body>
</html>
