<?php

    session_start();
    if(!isset($_SESSION['user_ID'])) {
        header("Location: ./Log In.php");
    }
    
    require './connect.php';

    $res = mysqli_query($conn, "SELECT users_information.*, users.username, users.email FROM users_information INNER JOIN users ON users_information.user_id = users.user_ID WHERE 
        users.user_id = {$_SESSION['user_ID']};
    ");

    $existing_data_res = mysqli_query($conn, "SELECT * FROM users WHERE users.user_id = {$_SESSION['user_ID']};");

    $orders_res = mysqli_query($conn, "SELECT * FROM orders WHERE user_id = {$_SESSION['user_ID']};");

    $user_data = $res->fetch_assoc();
    $existing_data = $existing_data_res->fetch_assoc();

    $pending_orders = 0;
    $active_orders = 0;
    $delivered_orders = 0;

    foreach($orders_res as $order) {

        $order_item = mysqli_query($conn, "SELECT * FROM order_item WHERE order_id = {$order['id']};");
        $total_sum = 0;

        foreach($order_item as $item) {
            $total_sum = $total_sum + ($item['quantity']*$item['price']);
        }

        switch($order['status']) {
            case 'p':
                ++$pending_orders;
                break;
            case 'a':
                ++$active_orders;
                break;
            case 'd':
                ++$delivered_orders;
                break;
            default:
                break;
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet"
            href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
        <link rel="stylesheet" href="./CSS/Header.css">
        <link rel="stylesheet" href="./CSS/Profile.css">
        <title>Profile</title>
    </head>
    <body>

        <?php include "./components/Header.html" ?>

        <div class="container">
            <div style="display: flex; justify-content: space-between;">
                <h1 id="container-section-label">
                    Your Profile
                </h1>
                <a href="./EditProfile.php" class="edit-profile-link">Edit</a>
            </div>
            <div class="personal-information-container">
                <div class="profile-picture-container">
                    <img src="./svgs/user-solid.svg" id="profile-picture">
                </div>
                <div>
                    <div class="profile-name-label">
                        <?php
                            if(mysqli_num_rows($res) == 0) {

                                if(mysqli_num_rows($existing_data_res) != 0) {
                                    echo $existing_data['username'];
                                }
                                else {
                                    echo 'None';
                                }
                            }
                            else {
                                echo $user_data['username'];
                            }
                        ?>
                        </div>
                    <div class="personal-information-details">
                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Email
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {

                                        if(mysqli_num_rows($existing_data_res) != 0) {
                                            echo $existing_data['email'];
                                        }
                                        else {
                                            echo 'None';
                                        }
                                    }
                                    else {
                                        echo $user_data['email'];
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Address
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['address'];
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                City
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['city'];
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Postal Code
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['postal_code'];
                                    }
                                ?>
                            </div>
                        </div>

                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Име
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['name'];
                                    }
                                ?>
                            </div>
                        </div>
                        
                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Презиме
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['surname'];
                                    }
                                ?>
                            </div>
                        </div>

                        <div class="personal-information-card">
                            <div class="persononal-information-card-header">
                                Тел. Број
                            </div>
                            <div class="personal-information-card-value">
                                <?php
                                    if(mysqli_num_rows($res) == 0) {
                                        echo 'None';
                                    }
                                    else {
                                        echo $user_data['phone_number'];
                                    }
                                ?>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="container" style="width: 95%;">
            <h1 id="container-section-label">
                Pending Orders
            </h1>
            <div class="order-information-container">
                <?php
                    if($pending_orders >= 1) {
                        foreach($orders_res as $order) {
                            if($order['status'] == 'p') {
                                ?>
                                <div class="order">
                                    <div class="order-icon">
                                        <img src="./svgs/bx-package.svg" width="100" height="100">
                                    </div>
                                    <div class="order-information">
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Number:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['id'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Date:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['order_date'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Total Sum:
                                            </h3>
                                            <div class="order-card-value">
                                                $
                                                <?php echo $order["total_sum"] ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                            }
                        }
                    }
                    else {
                        echo 'You have no pending orders!';
                    }
                ?>
                
            <h1 id="container-section-label">
                Active Orders
            </h1>

            <div class="order-information-container">
                <?php
                    if($active_orders >= 1) {
                        foreach($orders_res as $order) {
                            if($order['status'] == 'a') {
                                ?>
                                <div class="order">
                                    <div class="order-icon">
                                        <img src="./svgs/bx-package.svg" width="100" height="100">
                                    </div>
                                    <div class="order-information">
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Number:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['id'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Date:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['order_date'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Total Sum:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order["total_sum"] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Shipped Date:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['shipped_date'] ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                            }
                        }
                    }
                    else {
                        echo 'You have no active orders!';
                    }
                ?>

            <h1 id="container-section-label">
                Delivered Orders
            </h1>

            <div class="order-information-container">
            <?php
                    if($delivered_orders >= 1) {
                        foreach($orders_res as $order) {
                            if($order['status'] == 'd') {
                                ?>
                                <div class="order">
                                    <div class="order-icon">
                                        <img src="./svgs/bx-package.svg" width="100" height="100">
                                    </div>
                                    <div class="order-information">
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Number:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['id'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Order Date:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['order_date'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Total Sum:
                                            </h3>
                                            <div class="order-card-value">
                                                $
                                                <?php echo $order["total_sum"] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Shipped Date:
                                            </h3>
                                            <div class="order-card-value">
                                                $
                                                <?php echo $order['shipped_date'] ?>
                                            </div>
                                        </div>
                                        <div class="order-card">
                                            <h3 class="order-card-header">
                                                Arrived Date:
                                            </h3>
                                            <div class="order-card-value">
                                                <?php echo $order['arrived_date'] ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                            }
                        }
                    }
                    else {
                        echo 'You have no delivered orders!';
                    }
                ?>
            </div>
        </div>
        </div>
        </div>

        <section class="footer-class">
            <div class="footer-div">
                <div class="info-footer-first">
                    <img src="image/NewLogo.png">
                    <p>бул. АСНОМ 14 <br> Скопје, Македонија</p>
                    <p>+389 71 111 222</p>
                    <p>innovabuisness@gmail.com</p>
                </div>
    
                <div class="info-footer-second">
                    <h4>Помош</h4>
                    <p><a href="./Information/Contact.html">Контакт</a></p>
                    <p><a href="./Information/AboutUs.html">За нас</a></p>
                    <p><a href="./Information/Privacy.html">Политика на приватност</a></p>
                </div>
    
                <div class="info-footer-third">
                    <h4>Customers</h4>
                    <p>Гаранција</p>
                    <p>Студенски дискоунт</p>
                    <p>Return policy</p>
                </div>
            </div>
         </section>
    </body>
</html>