<?php

    session_start();
    if(!isset($_SESSION['user_ID'])) {
        header("Location: ./Log In.php");
    }
    require "./connect.php";

    if(isset($_POST['submit']) && isset($_POST['product_id'])) {

        if($_POST['submit'] == 'Remove') {
            $res = mysqli_query($conn, "DELETE FROM wishlist WHERE user_id = {$_SESSION['user_ID']} AND product_id = {$_POST['product_id']};");
        }
    }

    function get_wishlist_products() {
        global $conn;
        $products = [];
        $res = mysqli_query($conn, "SELECT products.product_id, products.name, products.category, products.price, products.discount, products.image1 FROM products INNER JOIN wishlist ON 
	                                    products.product_id = wishlist.product_id WHERE user_id = {$_SESSION['user_ID']};");

        foreach($res as $row) {
            $products[] = $row;
        }

        return $products;
    }

    $product_list = get_wishlist_products();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wishlist</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.0.3/css/font-awesome.css">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="/CSS/Cart.css">
    <link rel="stylesheet" href="/CSS/Header.css">
</head>
<body>

    <?php include './components/Header.html' ?>

    <section>
        <div class="pagination">
            <p>Home > Wishlist</p>
        </div>
        <div class="container px-4 py-5 mx-auto">
            <div class="row d-flex justify-content-center">
                <?php if(count($product_list) >= 1) {?>
                <div class="col-5">
                    <h4 class="heading">Wishlist</h4>
                </div>
                    <div class="col-7">
                        <div class="row text-right">
                            <div class="col-4">
                                <h6 class="mt-2">Price</h6>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        
            <?php

                foreach($product_list as $product) {
                    ?>
                        <div class="row d-flex justify-content-center border-top">
                            <div class="col-5">
                                <div class="row d-flex">
                                    <div class="book">
                                        <img src="<?php 
                                            if($product['image1'] != null) {
                                                $first_image = basename(strrchr($product['image1'], '/'));
                                                $first_image = str_replace(array("'"), '', $first_image);
                                                echo "./UPLOADED_IMAGES/".$first_image;
                                            }
                                        ?>" class="book-img">
                                    </div>
                                    <div class="my-auto flex-column d-flex pad-left">
                                        <h6 class="mob-text"><?php echo $product['name'] ?></h6>
                                        <p class="mob-text"><?php echo $product['category'] ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="my-auto col-7">
                                <div class="row text-right">
                                    <div class="col-4">
                                        <h6 class="mob-text">
                                            <?php
                                                $discountAmount = $product['price'] * ($product['discount'] / 100);
                                                echo "$".($product['price'] - $discountAmount); 
                                            ?>
                                        </h6>
                                    </div>
                                    <div class="col-4">
                                        <form action="./Products.php" method="GET">
                                            <input type="hidden" name="product_id" value="<?php echo $product['product_id'] ?>">
                                            <input class="btn btn-sm btn-success" type="submit" name="submit" value="add-to-cart">
                                        </form>
                                        <form action="./Wishlist.php" method="POST">
                                            <input type="hidden" name="product_id" value="<?php echo $product['product_id'] ?>">
                                            <input class="btn btn-sm btn-danger" type="submit" name="submit" value="Remove">
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                }
                
                if(count($product_list) <= 0) {
                    echo '<p>Your wish list is empty!</p>';
                }
            ?>
        </div>
    </section>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>
</body>
</html>
