<?php

    session_start();

    if(!isset($_SESSION['user_ID']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
        header("Location: ./Log In.php");
    }

    require "./connect.php";

    $res = $conn->query("SELECT * FROM users", MYSQLI_USE_RESULT);
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="./CSS/FetchData.css">
        <title>Users</title>
    </head>
    <body>
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header">
                            <h2>Users</h2>
                        </div>
                        <div class="card-body">
                            <table class="table-container">
                                <tr>
                                    <th>User ID</th>
                                    <th>Username</th>
                                    <th>Email</th>
                                    <th>Password</th>
                                    <th>Is Admin</th>
                                    <th></th>
                                </tr>
                                <tr>
                                    <?php
                                        while($row = mysqli_fetch_assoc($res)){
                                    ?>
                                    <td><?php echo $row['user_ID']?></td>
                                    <td><?php echo $row['username']?></td>
                                    <td><?php echo $row['email']?></td>
                                    <td><?php echo $row['password']?></td>
                                    <td><?php echo (($row["is_admin"] == 1) ? "TRUE" : "FALSE" ) ?></td>
                                    <td>
                                        <?php 
                                            if($row["is_admin"] == 1) {
                                                echo "<a class=\"already-admin-button\">Admin</a>";
                                            }
                                            else { ?>
                                                <a href="./SetUserAdmin.php?user_id=<?php echo $row["user_ID"] ?>" class="make-admin-button">Make Admin</a>
                                            <?php 
                                            } ?>
                                    </td>
                                </tr>
                                <?php
                                }
                                ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>