<?php 
    
    session_start();

    if(!isset($_SESSION['user_ID']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
        header("Location: ./Log In.php");
    }

    require './connect.php';

    if(!isset($_GET['order_id'])) {
        header('Location: ./PendingOrders.php');
    }

    $res = mysqli_query($conn, "SELECT * FROM orders WHERE id = {$_GET['order_id']}; ");
    $order = $res->fetch_assoc();
    $order_items = mysqli_query($conn, "SELECT * FROM order_item WHERE order_id={$_GET['order_id']};");
    $total_price = 0;
    $products = [];

    foreach($order_items as $item) {
        $product_name = mysqli_query($conn, "SELECT name FROM products INNER JOIN order_item ON products.product_id = order_item.product_id WHERE order_item.id={$item['id']};")->fetch_assoc()['name'];
        $total_price = $total_price + ($item['quantity']*$item['price']);
        $products[] = ['Product Name' => $product_name, 'Quantity' => $item['quantity'], 'Price per unit' => $item['price'], 'Product ID' => $item['product_id']];
    }
?>


<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="./CSS/ViewOrder.css">
        <title>Order</title>
    </head>
    <body>
        <div class="container">
            <div class="card">
                <div class="card-header">
                    Order Number
                </div>
                <div class="card-value">
                    <?php echo $order['id'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    User ID
                </div>
                <div class="card-value">
                    <?php echo $order['user_id'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Order Date
                </div>
                <div class="card-value">
                    <?php echo $order['order_date'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Shipped Date
                </div>
                <div class="card-value">
                    <?php echo $order['shipped_date'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Arrived Date
                </div>
                <div class="card-value">
                    <?php echo $order['arrived_date'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Status
                </div>
                <div class="card-value">
                    <?php
                        switch($order['status']) {
                            case 'p':
                                echo 'PENDING';
                                break;
                            case 'a':
                                echo 'ACTIVE';
                                break;
                            case 'd':
                                echo 'DELIVERED';
                                break;
                            default:
                                echo 'INVALID';
                                break;
                        }
                    ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Address
                </div>
                <div class="card-value">
                    <?php echo $order['address'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    City
                </div>
                <div class="card-value">
                    <?php echo $order['city'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Postal Code
                </div>
                <div class="card-value">
                    <?php echo $order['postal_code'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Phone Number
                </div>
                <div class="card-value">
                    <?php echo $order['phone_number'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Name
                </div>
                <div class="card-value">
                    <?php echo $order['name'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Surname
                </div>
                <div class="card-value">
                    <?php echo $order['surname'] ?>
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    Price
                </div>
                <div class="card-value">
                    <?php echo '$'.$total_price ?>
                </div>
            </div>
            <br>
            <br>
            <?php
                foreach($products as $product) {
                    ?>

                    <div class="product">

                    <?php
                    foreach($product as $key => $value) {
                        ?>
                            <div class="card">
                                <div class="card-header">
                                    <?php echo $key ?>
                                </div>
                                <div class="card-value">
                                    <?php
                                        if($key == 'Price per unit') echo '$';
                                        echo $value 
                                    ?>
                                </div>
                            </div>
                        <?php
                    }
                    ?>
                    </div>
                    <br>
                    <br>
                    <?php
                }

            ?>
        </div>
    </body>
</html>