<?php
    session_start();
    if(!isset($_SESSION['user_ID'])) {
        header("Location: ./Log In.php");
    }    
    require "./connect.php";

    if(isset($_POST['submit']) && isset($_POST['product_id'])) {

        if($_POST['submit'] == 'Remove') {
            $res = mysqli_query($conn, "DELETE FROM cart WHERE user_id = {$_SESSION['user_ID']} AND product_id = {$_POST['product_id']};");
        }
    }

    function get_cart_products() {
        global $conn;
        $products = [];
        $res = mysqli_query($conn, "SELECT cart.quantity, products.product_id, products.name, products.category, products.price, products.discount, products.image1 FROM products INNER JOIN cart ON 
	                                    products.product_id = cart.product_id WHERE user_id = {$_SESSION['user_ID']};");

        foreach($res as $row) {
            $products[] = $row;
        }

        return $products;
    }

    $product_list = get_cart_products();
    $sub_total_price = 0.0;
    $shipping_price = 2;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cart</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.0.3/css/font-awesome.css">
    <link rel="stylesheet" href="https://unpkg.com/boxicons@latest/css/boxicons.min.css">
    <link rel="stylesheet" href="./CSS/Header.css">
    <link rel="stylesheet" href="./CSS/Cart.css">
</head>
<body>
    <?php include './components/Header.html' ?>
    
        <section>
        <div class="pagination">
            <p>Home > Shopping Cart</p>
        </div>
    <div class="container px-4 py-5 mx-auto">
        <div class="row d-flex justify-content-center">
            <div class="col-5">
                <h4 class="heading">Shopping Cart</h4>
            </div>
            <div class="col-7">
                <div class="row text-right">
                    <div class="col-4">
                        <h6 class="mt-2">Quantity</h6>
                    </div>
                    <div class="col-4">
                        <h6 class="mt-2">Price</h6>
                    </div>
                </div>
            </div>
        </div>

        <?php
            foreach($product_list as $product) { ?>
                <div class="row d-flex justify-content-center border-top">
                    <div class="col-5">
                        <div class="row d-flex">
                            <div class="book">
                                <img src="<?php 
                                    if($product['image1'] != null) {
                                        $first_image = basename(strrchr($product['image1'], '/'));
                                        $first_image = str_replace(array("'"), '', $first_image);
                                        echo "./UPLOADED_IMAGES/".$first_image;
                                    }
                                ?>" class="book-img">
                            </div>
                            <div class="my-auto flex-column d-flex pad-left">
                                <h6 class="mob-text"><?php echo $product['name'] ?></h6>
                                <p class="mob-text"><?php echo $product['category'] ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="my-auto col-7">
                        <div class="row text-right">
                            <div class="col-4">
                                <div class="row d-flex justify-content-end px-3">
                                    <p class="mb-0" id="cnt1"><?php echo $product['quantity'] ?></p>
                                </div>
                            </div>
                            <div class="col-4">
                                <h6 class="mob-text">
                                    <?php
                                        $discountAmount = $product['price'] * ($product['discount'] / 100);
                                        $price_amount = (($product['price'] - $discountAmount) * $product['quantity']);
                                        $sub_total_price += $price_amount;
                                        echo "$".$price_amount;
                                    ?>
                                </h6>
                            </div>
                            <form action="./Cart.php" method="POST">
                                <input type="hidden" name="product_id" value="<?php echo $product['product_id'] ?>">
                                <input class="btn btn-sm btn-danger" type="submit" name="submit" value="Remove">
                            </form>
                        </div>
                    </div>
                </div>
            <?php
            }
        ?>
    
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card">
                    <div class="row">
                        <div class="col-lg-3 radio-group">
                            <div class="row d-flex px-3 radio">
                                <img class="pay" src="https://i.imgur.com/WIAP9Ku.jpg">
                                <p class="my-auto">Credit Card</p>
                            </div>
                            <div class="row d-flex px-3 radio gray">
                                <img class="pay" src="https://i.imgur.com/OdxcctP.jpg">
                                <p class="my-auto">Debit Card</p>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="row px-2">
                                <div class="form-group col-md-6">
                                    <label class="form-control-label">Name on Card</label>
                                    <input type="text" id="cname" name="cname" placeholder="John Doe">
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="form-control-label">Card Number</label>
                                    <input type="text" id="cnum" name="cnum" placeholder="1111 2222 3333 4444" maxlength="19">
                                </div>
                            </div>
                            <div class="row px-2">
                                <div class="form-group col-md-6">
                                    <label class="form-control-label">Expiration Date</label>
                                    <input type="text" id="exp" name="exp" placeholder="MM/YYYY" maxlength="7">
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="form-control-label">CVV</label>
                                    <input type="text" id="cvv" name="cvv" placeholder="***" maxlength="3">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 mt-2">
                            <div class="row d-flex justify-content-between px-4">
                                <p class="mb-1 text-left">Subtotal</p>
                                <h6 class="mb-1 text-right">$<?php echo $sub_total_price ?></h6>
                            </div>
                            <div class="row d-flex justify-content-between px-4">
                                <p class="mb-1 text-left">Shipping</p>
                                <h6 class="mb-1 text-right">$<?php echo $shipping_price ?></h6>
                            </div>
                            <div class="row d-flex justify-content-between px-4" id="tax">
                                <p class="mb-1 text-left">Total</p>
                                <h6 class="mb-1 text-right">$<?php echo $sub_total_price + $shipping_price ?></h6>
                            </div>
                            <form action="./CreateOrder.php" method="POST">
                                <input type="hidden" name="user_id" value="<?php echo $_SESSION['user_ID'] ?>">
                                <button class="btn-block btn-blue">
                                    <span>
                                        <span id="checkout">Checkout</span>
                                        <span id="check-amt">$<?php echo $sub_total_price + $shipping_price ?></span>
                                    </span>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>
    <script src="Cart.js"></script>
</body>
</html>