const db = require('./db');

exports.getAll = (cb) => {
  db.query('SELECT * FROM product', cb);
};

exports.getAvailable = (cb) => {
  db.query("SELECT * FROM product WHERE Status = 'available'", cb);
};

exports.getById = (id, cb) => {
  db.query("SELECT * FROM product WHERE ProductID = $1", [id], cb);
};

exports.addProduct = (data, cb) => {
  const { ProductID, Model, Price, LicensePlate, Status } = data;
  db.query('INSERT INTO product VALUES ($1, $2, $3, $4, $5)', [ProductID, Model, Price, LicensePlate, Status], cb);
};

exports.updateStatus = (id, status, cb) => {
  db.query('UPDATE product SET Status = $1 WHERE ProductID = $2', [status, id], cb);
};