const express = require('express');
const router = express.Router();
const pool = require('../models/db');
const productController = require('../controllers/productController');

router.get("/", async (req, res) => {
    try {
      const result = await pool.query(`
        SELECT 
          p.productid, p.model, p.price, p.licenseplate, p.status,
          CASE 
            WHEN t.hp IS NOT NULL THEN 'truck'
            WHEN tr.capacity IS NOT NULL THEN 'trailer'
          END AS type,
          JSON_BUILD_OBJECT('HP', t.hp, 'Capacity', tr.capacity) AS specs
        FROM product p
        LEFT JOIN truck t ON p.productid = t.productid
        LEFT JOIN trailer tr ON p.productid = tr.productid
      `);
  
      const products = result.rows.map(p => ({
        ProductID: p.productid,
        Model: p.model,
        Price: p.price,
        LicensePlate: p.licenseplate,
        Status: p.status,
        type: p.type,
        specs: typeof p.specs === 'string' ? JSON.parse(p.specs) : p.specs
      }));
      
      res.json(products);
    } catch (err) {
      console.error("Error loading products:", err);
      res.status(500).json({ error: "Failed to load products" });
    }
  });
router.post('/', productController.addProduct);
router.put('/:id', productController.updateProduct);
router.delete('/:id', productController.deleteProduct);

module.exports = router;
