drop table if exists Korisnici cascade;
drop table if exists Dostavuvaci cascade;
drop table if exists Vraboteni cascade;
drop table if exists Kupuvaci cascade;
drop table if exists Komentari cascade;
drop table if exists Naracki cascade;
drop table if exists Proizvodi cascade;
drop table if exists Cena cascade;
drop table if exists Magacini cascade;
drop table if exists Kategorii cascade;
drop table if exists Garancija cascade;
drop table if exists Parce cascade;
drop table if exists Kompanija  cascade;
drop table if exists Dostavuvanja cascade;
drop table if exists komentar_na_proizvod cascade;
drop table if exists parce_dostapno_vo_magacini cascade;
drop table if exists parce_e_del_od_naracki cascade;



create table Korisnici(
korisnicko_ime varchar(20) primary key unique,
lozinka varchar(20) not null,
e_posta varchar(30) not null,
telefonski_broj varchar(9)
);

create table Dostavuvaci(
korisnicko_ime varchar(20) primary key ,
constraint fk_dostavuvaci_korisnik foreign key (korisnicko_ime)
references korisnici(korisnicko_ime)
);

create table Vraboteni(
korisnicko_ime varchar(20) primary key ,
constraint fk_vraboteni_korisnik foreign key (korisnicko_ime)
references korisnici(korisnicko_ime)
);

create table Kupuvaci(
korisnicko_ime varchar(20) primary key ,
constraint fk_kupuvaci_korisnik foreign key (korisnicko_ime)
references korisnici(korisnicko_ime)
);

create table Kompanija (
ime varchar(25) primary key 
);

create table Proizvodi(
id_proizvod serial primary key,
kolicina integer not null,
ime_proizvod varchar(15) not null,
prosek_ocenka integer,
boja varchar(8),
karakteristiki varchar(225),
ime varchar(25),
constraint fk_proizvod_od_kompanija foreign key (ime) references kompanija (ime)
);


create table Naracki(
id_naracka serial primary key,
suma integer not null,
nacin_na_plakanje varchar(10) not null,
status varchar(10) not null,
data_na_naracka timestamp default now(),
korisnicko_ime varchar(20),
constraint fk_kupuvac_pravi_naracka foreign key (korisnicko_ime) references kupuvaci(korisnicko_ime)
);


create table Dostavuvanja(
id_dostavuvanja serial primary key,
data_na_dostavuvanje timestamp not null,
id_naracka serial,
korisnicko_ime varchar(20),
constraint fk_dostavuvanja_za_naracka foreign key (id_naracka) references naracki (id_naracka),
constraint fk_dostavuvac_vrsi_dostavuvanja foreign key (korisnicko_ime) references dostavuvaci (korisnicko_ime)
);



create table Parce(
id_parce serial primary key,
id_proizvod serial,
constraint fk_proizvod_ima_parce foreign key (id_proizvod) references proizvodi (id_proizvod)
);


create table Magacini(
id_magacin serial primary key,
lokacija varchar(20) not null,
korisnicko_ime varchar(20),
constraint fk_vraboten_raboti_vo_magacin foreign key (korisnicko_ime) references vraboteni (korisnicko_ime)
);


create table Cena(
id_cena serial primary key,
datum_na_cena timestamp default now(),
popust integer,
iznos integer not null,
id_proizvod serial,
constraint fk_proizvod_e_so_cena foreign key (id_proizvod) 
	references proizvodi (id_proizvod)
);


create table Garancija(
shifra serial primary key,
datum_do timestamp not null,
datum_od timestamp not null,
id_proizvod serial,
constraint fk_proizvod_e_pod_garancija foreign key (id_proizvod) references proizvodi (id_proizvod)
);


create table Kategorii(
id_kategorija serial primary key,
ime varchar(25) not null ,
id_nadkategorija integer,
id_proizvod serial,
 constraint fk_nadkategorija foreign key (id_nadkategorija)
        references kategorii(id_kategorija),
constraint fk_proizvod_se_sodrzi_vo_kategorija foreign key (id_proizvod) 
	references proizvodi (id_proizvod)
);

--prasaj za dava
create table Komentari(
id_proizvod serial ,
korisnicko_ime varchar(20),
tekst varchar(225) not null,
constraint fk_komentar_proizvod foreign key (id_proizvod)
references proizvodi(id_proizvod),
constraint fk_komentar_korisnicko_ime foreign key (korisnicko_ime)
references korisnici(korisnicko_ime),
constraint pk_komentari primary key(id_proizvod,korisnicko_ime),
constraint kupuvac_dava_komentar foreign key (korisnicko_ime) references kupuvaci(korisnicko_ime)
);


create table parce_e_del_od_naracki(
id_parce serial not null,
id_naracka serial not null,
constraint fk_parce_za_naracka foreign key(id_naracka) references naracki (id_naracka),
constraint fk_naracka_za_parce foreign key(id_parce) references parce (id_parce)
);

create table parce_dostapno_vo_magacini (
id_parce serial not null,
id_magacin serial not null,
constraint fk_parce_dostapno_vo_magacini foreign key (id_magacin) references magacini(id_magacin),
constraint fk_magacini_dostapno_vo_parce foreign key (id_parce) references parce(id_parce)
);

create table komentar_na_proizvod (
id_proizvod serial not null,
korisnicko_ime varchar(20) not null,
constraint fk_kom_na_pro foreign key (id_proizvod) references proizvodi (id_proizvod),
constraint fk_proizvod_na_komentar foreign key (korisnicko_ime, id_proizvod) references komentari(korisnicko_ime, id_proizvod)
);







