
drop schema if exists project cascade;

create schema project;

drop table if exists bolnica cascade;
drop table if exists bolnica_telefonski_broevi cascade;
drop table if exists covek cascade;
drop table if exists doktor cascade;
drop table if exists lekovi cascade;
drop table if exists oddel cascade;
drop table if exists pacient cascade;
drop table if exists pregled cascade;
drop table if exists recepta cascade;
drop table if exists rezervacija cascade;
drop table if exists specijalnost cascade;
drop table if exists telefonski_broevi cascade;
drop table if exists termin cascade;
drop table if exists transakcija cascade;
drop table if exists upat cascade;

-- Covek (covek_id, e-mail, password, ime, prezime, EMBG)

create table covek(
	covek_id serial,
	email varchar (50) not null unique,
	pass varchar (50) not null,
	ime varchar (50) not null,
	prezime varchar (50) not null,
	embg char (13) not null unique,
	constraint pk_covek_id primary key (covek_id),
	constraint ck_pass check (length (pass) >= 8)
);



-- Telefonski_br (covek_id*(Covek), telefonski_br)

create table telefonski_broevi(
	covek_broj_id integer,
	telefonski_broj varchar (30),
	constraint pk_telefonski_broj primary key (covek_broj_id, telefonski_broj),
	constraint fk_telefonski_br_covek foreign key (covek_broj_id) references covek(covek_id)
);


--Specijalnost (spec_id, naziv)

create table specijalnost(
	spec_id serial,
	naziv varchar (100) not null,
	constraint pk_spec_id primary key (spec_id)
);



-- Bolnica (bolnica_id, naziv, smetka_bolnica, grad, broj, ulica)

create table bolnica(
	bolnica_id serial,
	naziv varchar (100) not null,
	grad varchar (20) not null,
	broj integer not null,
	ulica varchar (100) not null,
	smetka_bolnica varchar (100) not null unique,
	constraint pk_bolnica_id primary key (bolnica_id)
);



-- Bolnica_telefonski_br (bolnica_id*(Bolnica), telefonski_br)

create table bolnica_telefonski_broevi(
	bolnica_id integer,
	telefonski_br_bolnica varchar (30),
	constraint pk_telefonski_broj_bolnica primary key (bolnica_id, telefonski_br_bolnica),
	constraint fk_telefonski_br_bolnica foreign key (bolnica_id) references bolnica(bolnica_id)
);



--Oddel (bolnica_id*(Bolnica), oddel_id, naziv, spec_id*(Specijalnost))

create table oddel(
	bolnica_id integer,
	oddel_id serial,
	naziv varchar (100) not null,
	spec_id integer,
	constraint pk_oddel_id primary key (bolnica_id, oddel_id),
	constraint fk_oddel_id foreign key (bolnica_id) references bolnica(bolnica_id),
	constraint fk_specijalnot_vo_oddel foreign key (spec_id) references specijalnost(spec_id)
);



-- Doktor (doktor_id*(Covek), br_licenca, opis, spec_id*(Specijalnost), (bolnica_id, oddel_id)*(Oddel))

create table Doktor(
	doktor_id integer,
	br_licenca integer not null,
	opis varchar (50),
	spec_id integer,
	oddel_id integer not null,
	bolnica_id integer,
	constraint pk_doktor_id primary key (doktor_id),
	constraint fk_covek_id foreign key (doktor_id) references covek(covek_id),
	constraint fk_doktor_specijalnost foreign key (spec_id) references specijalnost(spec_id),
	constraint fk_doktor_raboti_oddel foreign key (bolnica_id, oddel_id) references oddel(bolnica_id, oddel_id)
);



-- Termin (doktor_id*(Doktor), termin_id, vreme)

create table Termin(
	termin_id serial,
	doktor_id integer,
	vreme timestamp not null,
	constraint pk_termin primary key (doktor_id, termin_id),
	constraint fk_doktor_id foreign key (doktor_id) references doktor(doktor_id)
);



-- Pacient (covek_pacient_id*(Covek), pacient_id)

create table pacient(
	covek_pacient_id integer,
	pacient_id integer not null,
	constraint pk_pacient_covek_id primary key (covek_pacient_id),
	constraint fk_pacient_covek_id foreign key (covek_pacient_id) references covek(covek_id)
);



-- Pregled (pregled_id, vreme, doktor_id*(Doktor), covek_pacient_id*(Pacient))

create table pregled (
	pregled_id serial,
	vreme timestamp not null,
	doktor_id integer,
	covek_pacient_id integer not null,
	constraint pk_pregled_id primary key (pregled_id),
	constraint fk_doktor_pregleduva foreign key (doktor_id) references doktor(doktor_id),
	constraint fk_odi_na_prelged foreign key (covek_pacient_id) references pacient(covek_pacient_id)
);



-- Upat (upat_id, dijagnoza, covek_pacient_id*(Pacient), pregled_id*(Pregled), oddel_id*(Oddel))

create table upat (
	upat_id serial,
	dijagnoza varchar (150) not null,
	covek_pacient_id integer not null,
	pregled_id integer,
	bolnica_id integer not null,
	oddel_id integer not null,
	constraint pk_upat_id primary key (upat_id),
	constraint fk_pacinet_dobiva_upat foreign key (covek_pacient_id) references pacient(covek_pacient_id),
	constraint fk_se_dobiva_upat_od_prelged foreign key (pregled_id) references pregled(pregled_id),
	constraint fk_izdaden_za_oddel foreign key (bolnica_id, oddel_id) references oddel(bolnica_id, oddel_id)
);



-- Rezervacija (rezervacija_id, upat_id*(Upat), termin_id*(Termin))

create table rezervacija (
	rezervacija_id serial,
	upat_id integer,
	termin_id integer not null,
	doktor_id integer not null,
	constraint pk_rezervacija_id primary key (rezervacija_id),
	constraint fk_upat_rezervacija foreign key (upat_id) references upat(upat_id),
	constraint fk_rezervacija_vo_termin foreign key (doktor_id, termin_id) references termin(doktor_id, termin_id)
);



--Transakcija (tran_id, suma, smetka_bolnica, rezervacija_id*(Rezervacija))

create table transakcija (
	tran_id serial,
	suma integer not null,
	smetka_bolnica varchar (100) not null,
	rezervacija_id integer,
	constraint pk_tran_id primary key (tran_id),
	constraint fk_transakcija_rezervacija foreign key (rezervacija_id) references rezervacija(rezervacija_id)
);



-- Lekovi (lek_id, ime_lek, genericko_ime)

create table lekovi (
	lek_id serial,
	ime_lek varchar (100) not null,
	genericko_ime varchar (100) not null,
	constraint pk_lek_id primary key (lek_id)
);



-- Recepta (recepta_id, datum_izdavanje, datum_vaznost, datum_kupuvanje, pregled_id*(Pregled), lek_id*(Lekovi), doktor_id*(Doktor), covek_pacient_id*(Pacient))

create table recepta (
	recepta_id serial,
	datum_izdavanje timestamp not null,
	datum_vaznost timestamp not null,
	datum_kupuvanje timestamp,
	pregled_id integer,
	lek_id integer not null,
	doktor_id integer not null,
	covek_pacient_id integer not null,
	constraint pk_recepta_id primary key (recepta_id),
	constraint fk_recepta_od_pregled foreign key (pregled_id) references pregled(pregled_id),
	constraint fk_lek_od_recepta foreign key (lek_id) references lekovi(lek_id),
	constraint fk_doktor_prepisuva_recepta foreign key (doktor_id) references doktor(doktor_id),
	constraint fk_recepta_pacient foreign key (covek_pacient_id) references pacient(covek_pacient_id)
);

