package com.example.moviezone.service.Impl;

import com.example.moviezone.model.User;
import com.example.moviezone.model.exceptions.UserNotFoundException;
import com.example.moviezone.repository.UserRepository;
import com.example.moviezone.service.UserService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    private final UserRepository userRepository;

    public UserServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public List<User> findAllUsers() {
        return userRepository.findAll();
    }

    @Override
    public User findById(Integer id) {
        return userRepository.findById(id).orElseThrow(UserNotFoundException::new);
    }
}
