package com.example.moviezone.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import javax.management.relation.Role;
import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;


@Entity
@Getter
@Setter
@ToString
@Table(name = "discounts")
public class Discount {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    Integer id_discount;

    LocalDate validity;

    String code;
    String type;
    Integer percent;

    public Discount() {
    }

    public Discount(LocalDate validity, String code, String type, Integer percent) {
        this.validity = validity;
        this.code = code;
        this.type = type;
        this.percent = percent;
    }
}
