import { CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
import { ElementRef, OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, Renderer2, EventEmitter, QueryList, TemplateRef, ChangeDetectorRef, NgZone } from '@angular/core';
import { AnimationEvent } from '@angular/animations';
import { OverlayService, PrimeNGConfig, SelectItem } from 'primeng/api';
import { FilterService } from 'primeng/api';
import { ControlValueAccessor } from '@angular/forms';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/api";
import * as i3 from "@angular/cdk/scrolling";
import * as i4 from "primeng/tooltip";
import * as i5 from "primeng/ripple";
export declare const DROPDOWN_VALUE_ACCESSOR: any;
export declare class DropdownItem {
    option: SelectItem;
    selected: boolean;
    label: string;
    disabled: boolean;
    visible: boolean;
    itemSize: number;
    template: TemplateRef<any>;
    onClick: EventEmitter<any>;
    onOptionClick(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<DropdownItem, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<DropdownItem, "p-dropdownItem", never, { "option": "option"; "selected": "selected"; "label": "label"; "disabled": "disabled"; "visible": "visible"; "itemSize": "itemSize"; "template": "template"; }, { "onClick": "onClick"; }, never, never>;
}
export declare class Dropdown implements OnInit, AfterViewInit, AfterContentInit, AfterViewChecked, OnDestroy, ControlValueAccessor {
    el: ElementRef;
    renderer: Renderer2;
    cd: ChangeDetectorRef;
    zone: NgZone;
    filterService: FilterService;
    config: PrimeNGConfig;
    overlayService: OverlayService;
    scrollHeight: string;
    filter: boolean;
    name: string;
    style: any;
    panelStyle: any;
    styleClass: string;
    panelStyleClass: string;
    readonly: boolean;
    required: boolean;
    editable: boolean;
    appendTo: any;
    tabindex: number;
    placeholder: string;
    filterPlaceholder: string;
    filterLocale: string;
    inputId: string;
    selectId: string;
    dataKey: string;
    filterBy: string;
    autofocus: boolean;
    resetFilterOnHide: boolean;
    dropdownIcon: string;
    optionLabel: string;
    optionValue: string;
    optionDisabled: string;
    optionGroupLabel: string;
    optionGroupChildren: string;
    autoDisplayFirst: boolean;
    group: boolean;
    showClear: boolean;
    emptyFilterMessage: string;
    emptyMessage: string;
    virtualScroll: boolean;
    itemSize: number;
    autoZIndex: boolean;
    baseZIndex: number;
    showTransitionOptions: string;
    hideTransitionOptions: string;
    ariaFilterLabel: string;
    ariaLabelledBy: string;
    filterMatchMode: string;
    maxlength: number;
    tooltip: string;
    tooltipPosition: string;
    tooltipPositionStyle: string;
    tooltipStyleClass: string;
    autofocusFilter: boolean;
    onChange: EventEmitter<any>;
    onFilter: EventEmitter<any>;
    onFocus: EventEmitter<any>;
    onBlur: EventEmitter<any>;
    onClick: EventEmitter<any>;
    onShow: EventEmitter<any>;
    onHide: EventEmitter<any>;
    onClear: EventEmitter<any>;
    containerViewChild: ElementRef;
    filterViewChild: ElementRef;
    accessibleViewChild: ElementRef;
    viewPort: CdkVirtualScrollViewport;
    editableInputViewChild: ElementRef;
    templates: QueryList<any>;
    private _disabled;
    get disabled(): boolean;
    set disabled(_disabled: boolean);
    overlay: HTMLDivElement;
    itemsWrapper: HTMLDivElement;
    itemTemplate: TemplateRef<any>;
    groupTemplate: TemplateRef<any>;
    selectedItemTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    emptyFilterTemplate: TemplateRef<any>;
    emptyTemplate: TemplateRef<any>;
    selectedOption: any;
    _options: any[];
    value: any;
    onModelChange: Function;
    onModelTouched: Function;
    optionsToDisplay: any[];
    hover: boolean;
    focused: boolean;
    overlayVisible: boolean;
    documentClickListener: any;
    scrollHandler: any;
    optionsChanged: boolean;
    panel: HTMLDivElement;
    dimensionsUpdated: boolean;
    hoveredItem: any;
    selectedOptionUpdated: boolean;
    _filterValue: string;
    searchValue: string;
    searchIndex: number;
    searchTimeout: any;
    previousSearchChar: string;
    currentSearchChar: string;
    documentResizeListener: any;
    virtualAutoScrolled: boolean;
    virtualScrollSelectedIndex: number;
    viewPortOffsetTop: number;
    preventModelTouched: boolean;
    id: string;
    labelId: string;
    listId: string;
    constructor(el: ElementRef, renderer: Renderer2, cd: ChangeDetectorRef, zone: NgZone, filterService: FilterService, config: PrimeNGConfig, overlayService: OverlayService);
    ngAfterContentInit(): void;
    ngOnInit(): void;
    get options(): any[];
    set options(val: any[]);
    get filterValue(): string;
    set filterValue(val: string);
    ngAfterViewInit(): void;
    get label(): string;
    get emptyMessageLabel(): string;
    get emptyFilterMessageLabel(): string;
    get filled(): any;
    updateEditableLabel(): void;
    getOptionLabel(option: any): any;
    getOptionValue(option: any): any;
    isOptionDisabled(option: any): any;
    getOptionGroupLabel(optionGroup: any): any;
    getOptionGroupChildren(optionGroup: any): any;
    onItemClick(event: any): void;
    selectItem(event: any, option: any): void;
    ngAfterViewChecked(): void;
    writeValue(value: any): void;
    resetFilter(): void;
    updateSelectedOption(val: any): void;
    registerOnChange(fn: Function): void;
    registerOnTouched(fn: Function): void;
    setDisabledState(val: boolean): void;
    onMouseclick(event: any): void;
    onOverlayClick(event: any): void;
    isInputClick(event: any): boolean;
    isOutsideClicked(event: Event): boolean;
    isEmpty(): boolean;
    onEditableInputClick(): void;
    onEditableInputFocus(event: any): void;
    onEditableInputChange(event: any): void;
    show(): void;
    onOverlayAnimationStart(event: AnimationEvent): void;
    onOverlayAnimationEnd(event: AnimationEvent): void;
    scrollToSelectedVirtualScrollElement(): void;
    updateVirtualScrollSelectedIndex(resetOffset: any): void;
    appendOverlay(): void;
    restoreOverlayAppend(): void;
    hide(): void;
    alignOverlay(): void;
    onInputFocus(event: any): void;
    onInputBlur(event: any): void;
    findPrevEnabledOption(index: any): any;
    findNextEnabledOption(index: any): any;
    onKeydown(event: KeyboardEvent, search: boolean): void;
    search(event: KeyboardEvent): void;
    searchOption(index: any): any;
    searchOptionInRange(start: any, end: any): any;
    searchOptionWithinGroup(index: any): any;
    findOptionIndex(val: any, opts: any[]): number;
    findOptionGroupIndex(val: any, opts: any[]): any;
    findOption(val: any, opts: any[], inGroup?: boolean): SelectItem;
    onFilterInputChange(event: any): void;
    activateFilter(): void;
    applyFocus(): void;
    focus(): void;
    bindDocumentClickListener(): void;
    unbindDocumentClickListener(): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    onWindowResize(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    clear(event: Event): void;
    onOverlayHide(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<Dropdown, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<Dropdown, "p-dropdown", never, { "scrollHeight": "scrollHeight"; "filter": "filter"; "name": "name"; "style": "style"; "panelStyle": "panelStyle"; "styleClass": "styleClass"; "panelStyleClass": "panelStyleClass"; "readonly": "readonly"; "required": "required"; "editable": "editable"; "appendTo": "appendTo"; "tabindex": "tabindex"; "placeholder": "placeholder"; "filterPlaceholder": "filterPlaceholder"; "filterLocale": "filterLocale"; "inputId": "inputId"; "selectId": "selectId"; "dataKey": "dataKey"; "filterBy": "filterBy"; "autofocus": "autofocus"; "resetFilterOnHide": "resetFilterOnHide"; "dropdownIcon": "dropdownIcon"; "optionLabel": "optionLabel"; "optionValue": "optionValue"; "optionDisabled": "optionDisabled"; "optionGroupLabel": "optionGroupLabel"; "optionGroupChildren": "optionGroupChildren"; "autoDisplayFirst": "autoDisplayFirst"; "group": "group"; "showClear": "showClear"; "emptyFilterMessage": "emptyFilterMessage"; "emptyMessage": "emptyMessage"; "virtualScroll": "virtualScroll"; "itemSize": "itemSize"; "autoZIndex": "autoZIndex"; "baseZIndex": "baseZIndex"; "showTransitionOptions": "showTransitionOptions"; "hideTransitionOptions": "hideTransitionOptions"; "ariaFilterLabel": "ariaFilterLabel"; "ariaLabelledBy": "ariaLabelledBy"; "filterMatchMode": "filterMatchMode"; "maxlength": "maxlength"; "tooltip": "tooltip"; "tooltipPosition": "tooltipPosition"; "tooltipPositionStyle": "tooltipPositionStyle"; "tooltipStyleClass": "tooltipStyleClass"; "autofocusFilter": "autofocusFilter"; "disabled": "disabled"; "options": "options"; "filterValue": "filterValue"; }, { "onChange": "onChange"; "onFilter": "onFilter"; "onFocus": "onFocus"; "onBlur": "onBlur"; "onClick": "onClick"; "onShow": "onShow"; "onHide": "onHide"; "onClear": "onClear"; }, ["templates"], never>;
}
export declare class DropdownModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<DropdownModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<DropdownModule, [typeof Dropdown, typeof DropdownItem], [typeof i1.CommonModule, typeof i2.SharedModule, typeof i3.ScrollingModule, typeof i4.TooltipModule, typeof i5.RippleModule], [typeof Dropdown, typeof i2.SharedModule, typeof i3.ScrollingModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<DropdownModule>;
}
