export class ObjectUtils {
    static equals(obj1, obj2, field) {
        if (field)
            return (this.resolveFieldData(obj1, field) === this.resolveFieldData(obj2, field));
        else
            return this.equalsByValue(obj1, obj2);
    }
    static equalsByValue(obj1, obj2) {
        if (obj1 === obj2)
            return true;
        if (obj1 && obj2 && typeof obj1 == 'object' && typeof obj2 == 'object') {
            var arrA = Array.isArray(obj1), arrB = Array.isArray(obj2), i, length, key;
            if (arrA && arrB) {
                length = obj1.length;
                if (length != obj2.length)
                    return false;
                for (i = length; i-- !== 0;)
                    if (!this.equalsByValue(obj1[i], obj2[i]))
                        return false;
                return true;
            }
            if (arrA != arrB)
                return false;
            var dateA = obj1 instanceof Date, dateB = obj2 instanceof Date;
            if (dateA != dateB)
                return false;
            if (dateA && dateB)
                return obj1.getTime() == obj2.getTime();
            var regexpA = obj1 instanceof RegExp, regexpB = obj2 instanceof RegExp;
            if (regexpA != regexpB)
                return false;
            if (regexpA && regexpB)
                return obj1.toString() == obj2.toString();
            var keys = Object.keys(obj1);
            length = keys.length;
            if (length !== Object.keys(obj2).length)
                return false;
            for (i = length; i-- !== 0;)
                if (!Object.prototype.hasOwnProperty.call(obj2, keys[i]))
                    return false;
            for (i = length; i-- !== 0;) {
                key = keys[i];
                if (!this.equalsByValue(obj1[key], obj2[key]))
                    return false;
            }
            return true;
        }
        return obj1 !== obj1 && obj2 !== obj2;
    }
    static resolveFieldData(data, field) {
        if (data && field) {
            if (this.isFunction(field)) {
                return field(data);
            }
            else if (field.indexOf('.') == -1) {
                return data[field];
            }
            else {
                let fields = field.split('.');
                let value = data;
                for (let i = 0, len = fields.length; i < len; ++i) {
                    if (value == null) {
                        return null;
                    }
                    value = value[fields[i]];
                }
                return value;
            }
        }
        else {
            return null;
        }
    }
    static isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
    }
    static reorderArray(value, from, to) {
        let target;
        if (value && from !== to) {
            if (to >= value.length) {
                to %= value.length;
                from %= value.length;
            }
            value.splice(to, 0, value.splice(from, 1)[0]);
        }
    }
    static insertIntoOrderedArray(item, index, arr, sourceArr) {
        if (arr.length > 0) {
            let injected = false;
            for (let i = 0; i < arr.length; i++) {
                let currentItemIndex = this.findIndexInList(arr[i], sourceArr);
                if (currentItemIndex > index) {
                    arr.splice(i, 0, item);
                    injected = true;
                    break;
                }
            }
            if (!injected) {
                arr.push(item);
            }
        }
        else {
            arr.push(item);
        }
    }
    static findIndexInList(item, list) {
        let index = -1;
        if (list) {
            for (let i = 0; i < list.length; i++) {
                if (list[i] == item) {
                    index = i;
                    break;
                }
            }
        }
        return index;
    }
    static contains(value, list) {
        if (value != null && list && list.length) {
            for (let val of list) {
                if (this.equals(value, val))
                    return true;
            }
        }
        return false;
    }
    static removeAccents(str) {
        if (str && str.search(/[\xC0-\xFF]/g) > -1) {
            str = str
                .replace(/[\xC0-\xC5]/g, "A")
                .replace(/[\xC6]/g, "AE")
                .replace(/[\xC7]/g, "C")
                .replace(/[\xC8-\xCB]/g, "E")
                .replace(/[\xCC-\xCF]/g, "I")
                .replace(/[\xD0]/g, "D")
                .replace(/[\xD1]/g, "N")
                .replace(/[\xD2-\xD6\xD8]/g, "O")
                .replace(/[\xD9-\xDC]/g, "U")
                .replace(/[\xDD]/g, "Y")
                .replace(/[\xDE]/g, "P")
                .replace(/[\xE0-\xE5]/g, "a")
                .replace(/[\xE6]/g, "ae")
                .replace(/[\xE7]/g, "c")
                .replace(/[\xE8-\xEB]/g, "e")
                .replace(/[\xEC-\xEF]/g, "i")
                .replace(/[\xF1]/g, "n")
                .replace(/[\xF2-\xF6\xF8]/g, "o")
                .replace(/[\xF9-\xFC]/g, "u")
                .replace(/[\xFE]/g, "p")
                .replace(/[\xFD\xFF]/g, "y");
        }
        return str;
    }
}
//# sourceMappingURL=data:application/json;base64,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