import { ElementRef, OnDestroy, EventEmitter, AfterContentInit, QueryList, TemplateRef, EmbeddedViewRef, ViewContainerRef, ChangeDetectorRef, AfterViewChecked } from '@angular/core';
import { BlockableUI } from 'primeng/api';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/api";
import * as i3 from "primeng/tooltip";
import * as i4 from "primeng/ripple";
export declare class TabPanel implements AfterContentInit, OnDestroy {
    viewContainer: ViewContainerRef;
    cd: ChangeDetectorRef;
    closable: boolean;
    headerStyle: any;
    headerStyleClass: string;
    cache: boolean;
    tooltip: any;
    tooltipPosition: string;
    tooltipPositionStyle: string;
    tooltipStyleClass: string;
    templates: QueryList<any>;
    closed: boolean;
    view: EmbeddedViewRef<any>;
    _selected: boolean;
    _disabled: boolean;
    _header: string;
    _leftIcon: string;
    _rightIcon: string;
    loaded: boolean;
    id: string;
    contentTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    tabView: TabView;
    constructor(tabView: any, viewContainer: ViewContainerRef, cd: ChangeDetectorRef);
    ngAfterContentInit(): void;
    get selected(): boolean;
    set selected(val: boolean);
    get disabled(): boolean;
    set disabled(disabled: boolean);
    get header(): string;
    set header(header: string);
    get leftIcon(): string;
    set leftIcon(leftIcon: string);
    get rightIcon(): string;
    set rightIcon(rightIcon: string);
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TabPanel, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TabPanel, "p-tabPanel", never, { "closable": "closable"; "headerStyle": "headerStyle"; "headerStyleClass": "headerStyleClass"; "cache": "cache"; "tooltip": "tooltip"; "tooltipPosition": "tooltipPosition"; "tooltipPositionStyle": "tooltipPositionStyle"; "tooltipStyleClass": "tooltipStyleClass"; "selected": "selected"; "disabled": "disabled"; "header": "header"; "leftIcon": "leftIcon"; "rightIcon": "rightIcon"; }, {}, ["templates"], ["*"]>;
}
export declare class TabView implements AfterContentInit, AfterViewChecked, BlockableUI {
    el: ElementRef;
    cd: ChangeDetectorRef;
    orientation: string;
    style: any;
    styleClass: string;
    controlClose: boolean;
    scrollable: boolean;
    content: ElementRef;
    navbar: ElementRef;
    prevBtn: ElementRef;
    nextBtn: ElementRef;
    inkbar: ElementRef;
    tabPanels: QueryList<TabPanel>;
    onChange: EventEmitter<any>;
    onClose: EventEmitter<any>;
    activeIndexChange: EventEmitter<number>;
    initialized: boolean;
    tabs: TabPanel[];
    _activeIndex: number;
    preventActiveIndexPropagation: boolean;
    tabChanged: boolean;
    backwardIsDisabled: boolean;
    forwardIsDisabled: boolean;
    constructor(el: ElementRef, cd: ChangeDetectorRef);
    ngAfterContentInit(): void;
    ngAfterViewChecked(): void;
    initTabs(): void;
    open(event: Event, tab: TabPanel): void;
    close(event: Event, tab: TabPanel): void;
    closeTab(tab: TabPanel): void;
    findSelectedTab(): TabPanel;
    findTabIndex(tab: TabPanel): number;
    getBlockableElement(): HTMLElement;
    get activeIndex(): number;
    set activeIndex(val: number);
    updateInkBar(): void;
    updateScrollBar(index: any): void;
    updateButtonState(): void;
    onScroll(event: any): void;
    getVisibleButtonWidths(): any;
    navBackward(): void;
    navForward(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TabView, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TabView, "p-tabView", never, { "orientation": "orientation"; "style": "style"; "styleClass": "styleClass"; "controlClose": "controlClose"; "scrollable": "scrollable"; "activeIndex": "activeIndex"; }, { "onChange": "onChange"; "onClose": "onClose"; "activeIndexChange": "activeIndexChange"; }, ["tabPanels"], ["*"]>;
}
export declare class TabViewModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<TabViewModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TabViewModule, [typeof TabView, typeof TabPanel], [typeof i1.CommonModule, typeof i2.SharedModule, typeof i3.TooltipModule, typeof i4.RippleModule], [typeof TabView, typeof TabPanel, typeof i2.SharedModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TabViewModule>;
}
