import { AfterContentInit, OnInit, OnDestroy, EventEmitter, TemplateRef, QueryList, ElementRef, NgZone, AfterViewInit, OnChanges, SimpleChanges, ChangeDetectorRef } from '@angular/core';
import { TreeNode } from 'primeng/api';
import { Subscription } from 'rxjs';
import { PrimeTemplate, FilterService } from 'primeng/api';
import { SortMeta } from 'primeng/api';
import { BlockableUI } from 'primeng/api';
import { FilterMetadata } from 'primeng/api';
import { CdkVirtualScrollViewport } from '@angular/cdk/scrolling';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/paginator";
import * as i3 from "@angular/cdk/scrolling";
import * as i4 from "primeng/ripple";
import * as i5 from "primeng/api";
export declare class TreeTableService {
    private sortSource;
    private selectionSource;
    private contextMenuSource;
    private uiUpdateSource;
    private totalRecordsSource;
    sortSource$: import("rxjs").Observable<SortMeta | SortMeta[]>;
    selectionSource$: import("rxjs").Observable<unknown>;
    contextMenuSource$: import("rxjs").Observable<any>;
    uiUpdateSource$: import("rxjs").Observable<any>;
    totalRecordsSource$: import("rxjs").Observable<any>;
    onSort(sortMeta: SortMeta | SortMeta[]): void;
    onSelectionChange(): void;
    onContextMenu(node: any): void;
    onUIUpdate(value: any): void;
    onTotalRecordsChange(value: number): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeTableService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<TreeTableService>;
}
export declare class TreeTable implements AfterContentInit, OnInit, OnDestroy, BlockableUI, OnChanges {
    el: ElementRef;
    zone: NgZone;
    tableService: TreeTableService;
    filterService: FilterService;
    columns: any[];
    style: any;
    styleClass: string;
    tableStyle: any;
    tableStyleClass: string;
    autoLayout: boolean;
    lazy: boolean;
    lazyLoadOnInit: boolean;
    paginator: boolean;
    rows: number;
    first: number;
    pageLinks: number;
    rowsPerPageOptions: any[];
    alwaysShowPaginator: boolean;
    paginatorPosition: string;
    paginatorDropdownAppendTo: any;
    currentPageReportTemplate: string;
    showCurrentPageReport: boolean;
    showJumpToPageDropdown: boolean;
    showFirstLastIcon: boolean;
    showPageLinks: boolean;
    defaultSortOrder: number;
    sortMode: string;
    resetPageOnSort: boolean;
    customSort: boolean;
    selectionMode: string;
    selectionChange: EventEmitter<any>;
    contextMenuSelection: any;
    contextMenuSelectionChange: EventEmitter<any>;
    contextMenuSelectionMode: string;
    dataKey: string;
    metaKeySelection: boolean;
    compareSelectionBy: string;
    rowHover: boolean;
    loading: boolean;
    loadingIcon: string;
    showLoader: boolean;
    scrollable: boolean;
    scrollHeight: string;
    virtualScroll: boolean;
    virtualScrollDelay: number;
    virtualRowHeight: number;
    minBufferPx: number;
    maxBufferPx: number;
    frozenWidth: string;
    frozenColumns: any[];
    resizableColumns: boolean;
    columnResizeMode: string;
    reorderableColumns: boolean;
    contextMenu: any;
    rowTrackBy: Function;
    filters: {
        [s: string]: FilterMetadata;
    };
    globalFilterFields: string[];
    filterDelay: number;
    filterMode: string;
    filterLocale: string;
    onFilter: EventEmitter<any>;
    onNodeExpand: EventEmitter<any>;
    onNodeCollapse: EventEmitter<any>;
    onPage: EventEmitter<any>;
    onSort: EventEmitter<any>;
    onLazyLoad: EventEmitter<any>;
    sortFunction: EventEmitter<any>;
    onColResize: EventEmitter<any>;
    onColReorder: EventEmitter<any>;
    onNodeSelect: EventEmitter<any>;
    onNodeUnselect: EventEmitter<any>;
    onContextMenuSelect: EventEmitter<any>;
    onHeaderCheckboxToggle: EventEmitter<any>;
    onEditInit: EventEmitter<any>;
    onEditComplete: EventEmitter<any>;
    onEditCancel: EventEmitter<any>;
    containerViewChild: ElementRef;
    resizeHelperViewChild: ElementRef;
    reorderIndicatorUpViewChild: ElementRef;
    reorderIndicatorDownViewChild: ElementRef;
    tableViewChild: ElementRef;
    scrollableViewChild: any;
    scrollableFrozenViewChild: any;
    templates: QueryList<PrimeTemplate>;
    _value: TreeNode[];
    serializedValue: any[];
    _totalRecords: number;
    _multiSortMeta: SortMeta[];
    _sortField: string;
    _sortOrder: number;
    filteredNodes: any[];
    filterTimeout: any;
    colGroupTemplate: TemplateRef<any>;
    captionTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    bodyTemplate: TemplateRef<any>;
    loadingBodyTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    summaryTemplate: TemplateRef<any>;
    emptyMessageTemplate: TemplateRef<any>;
    paginatorLeftTemplate: TemplateRef<any>;
    paginatorRightTemplate: TemplateRef<any>;
    paginatorDropdownItemTemplate: TemplateRef<any>;
    frozenHeaderTemplate: TemplateRef<any>;
    frozenBodyTemplate: TemplateRef<any>;
    frozenFooterTemplate: TemplateRef<any>;
    frozenColGroupTemplate: TemplateRef<any>;
    lastResizerHelperX: number;
    reorderIconWidth: number;
    reorderIconHeight: number;
    draggedColumn: any;
    dropPosition: number;
    preventSelectionSetterPropagation: boolean;
    _selection: any;
    selectionKeys: any;
    rowTouched: boolean;
    editingCell: Element;
    editingCellData: any;
    editingCellField: any;
    editingCellClick: boolean;
    documentEditListener: any;
    initialized: boolean;
    toggleRowIndex: number;
    ngOnInit(): void;
    ngAfterContentInit(): void;
    constructor(el: ElementRef, zone: NgZone, tableService: TreeTableService, filterService: FilterService);
    ngOnChanges(simpleChange: SimpleChanges): void;
    get value(): any[];
    set value(val: any[]);
    updateSerializedValue(): void;
    serializeNodes(parent: any, nodes: any, level: any, visible: any): void;
    serializePageNodes(): void;
    get totalRecords(): number;
    set totalRecords(val: number);
    get sortField(): string;
    set sortField(val: string);
    get sortOrder(): number;
    set sortOrder(val: number);
    get multiSortMeta(): SortMeta[];
    set multiSortMeta(val: SortMeta[]);
    get selection(): any;
    set selection(val: any);
    updateSelectionKeys(): void;
    onPageChange(event: any): void;
    sort(event: any): void;
    sortSingle(): void;
    sortNodes(nodes: any): void;
    sortMultiple(): void;
    sortMultipleNodes(nodes: any): void;
    multisortField(node1: any, node2: any, multiSortMeta: any, index: any): any;
    getSortMeta(field: string): SortMeta;
    isSorted(field: string): boolean;
    createLazyLoadMetadata(): any;
    resetScrollTop(): void;
    scrollToVirtualIndex(index: number): void;
    scrollTo(options: any): void;
    isEmpty(): boolean;
    getBlockableElement(): HTMLElement;
    onColumnResizeBegin(event: any): void;
    onColumnResize(event: any): void;
    onColumnResizeEnd(event: any, column: any): void;
    findParentScrollableView(column: any): any;
    resizeColGroup(table: any, resizeColumnIndex: any, newColumnWidth: any, nextColumnWidth: any): void;
    onColumnDragStart(event: any, columnElement: any): void;
    onColumnDragEnter(event: any, dropHeader: any): void;
    onColumnDragLeave(event: any): void;
    onColumnDrop(event: any, dropColumn: any): void;
    handleRowClick(event: any): void;
    handleRowTouchEnd(event: any): void;
    handleRowRightClick(event: any): void;
    toggleNodeWithCheckbox(event: any): void;
    toggleNodesWithCheckbox(event: Event, check: boolean): void;
    propagateSelectionUp(node: TreeNode, select: boolean): void;
    propagateSelectionDown(node: TreeNode, select: boolean): void;
    isSelected(node: any): boolean;
    findIndexInSelection(node: any): number;
    isSingleSelectionMode(): boolean;
    isMultipleSelectionMode(): boolean;
    equals(node1: any, node2: any): boolean;
    filter(value: any, field: any, matchMode: any): void;
    filterGlobal(value: any, matchMode: any): void;
    isFilterBlank(filter: any): boolean;
    _filter(): void;
    findFilteredNodes(node: any, paramsWithoutNode: any): boolean;
    isFilterMatched(node: any, { filterField, filterValue, filterConstraint, isStrictMode }: {
        filterField: any;
        filterValue: any;
        filterConstraint: any;
        isStrictMode: any;
    }): boolean;
    isNodeLeaf(node: any): boolean;
    hasFilter(): boolean;
    reset(): void;
    updateEditingCell(cell: any, data: any, field: any): void;
    isEditingCellValid(): boolean;
    bindDocumentEditListener(): void;
    unbindDocumentEditListener(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeTable, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TreeTable, "p-treeTable", never, { "columns": "columns"; "style": "style"; "styleClass": "styleClass"; "tableStyle": "tableStyle"; "tableStyleClass": "tableStyleClass"; "autoLayout": "autoLayout"; "lazy": "lazy"; "lazyLoadOnInit": "lazyLoadOnInit"; "paginator": "paginator"; "rows": "rows"; "first": "first"; "pageLinks": "pageLinks"; "rowsPerPageOptions": "rowsPerPageOptions"; "alwaysShowPaginator": "alwaysShowPaginator"; "paginatorPosition": "paginatorPosition"; "paginatorDropdownAppendTo": "paginatorDropdownAppendTo"; "currentPageReportTemplate": "currentPageReportTemplate"; "showCurrentPageReport": "showCurrentPageReport"; "showJumpToPageDropdown": "showJumpToPageDropdown"; "showFirstLastIcon": "showFirstLastIcon"; "showPageLinks": "showPageLinks"; "defaultSortOrder": "defaultSortOrder"; "sortMode": "sortMode"; "resetPageOnSort": "resetPageOnSort"; "customSort": "customSort"; "selectionMode": "selectionMode"; "contextMenuSelection": "contextMenuSelection"; "contextMenuSelectionMode": "contextMenuSelectionMode"; "dataKey": "dataKey"; "metaKeySelection": "metaKeySelection"; "compareSelectionBy": "compareSelectionBy"; "rowHover": "rowHover"; "loading": "loading"; "loadingIcon": "loadingIcon"; "showLoader": "showLoader"; "scrollable": "scrollable"; "scrollHeight": "scrollHeight"; "virtualScroll": "virtualScroll"; "virtualScrollDelay": "virtualScrollDelay"; "virtualRowHeight": "virtualRowHeight"; "minBufferPx": "minBufferPx"; "maxBufferPx": "maxBufferPx"; "frozenWidth": "frozenWidth"; "frozenColumns": "frozenColumns"; "resizableColumns": "resizableColumns"; "columnResizeMode": "columnResizeMode"; "reorderableColumns": "reorderableColumns"; "contextMenu": "contextMenu"; "rowTrackBy": "rowTrackBy"; "filters": "filters"; "globalFilterFields": "globalFilterFields"; "filterDelay": "filterDelay"; "filterMode": "filterMode"; "filterLocale": "filterLocale"; "value": "value"; "totalRecords": "totalRecords"; "sortField": "sortField"; "sortOrder": "sortOrder"; "multiSortMeta": "multiSortMeta"; "selection": "selection"; }, { "selectionChange": "selectionChange"; "contextMenuSelectionChange": "contextMenuSelectionChange"; "onFilter": "onFilter"; "onNodeExpand": "onNodeExpand"; "onNodeCollapse": "onNodeCollapse"; "onPage": "onPage"; "onSort": "onSort"; "onLazyLoad": "onLazyLoad"; "sortFunction": "sortFunction"; "onColResize": "onColResize"; "onColReorder": "onColReorder"; "onNodeSelect": "onNodeSelect"; "onNodeUnselect": "onNodeUnselect"; "onContextMenuSelect": "onContextMenuSelect"; "onHeaderCheckboxToggle": "onHeaderCheckboxToggle"; "onEditInit": "onEditInit"; "onEditComplete": "onEditComplete"; "onEditCancel": "onEditCancel"; }, ["templates"], never>;
}
export declare class TTBody {
    tt: TreeTable;
    treeTableService: TreeTableService;
    cd: ChangeDetectorRef;
    columns: any[];
    template: TemplateRef<any>;
    frozen: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable, treeTableService: TreeTableService, cd: ChangeDetectorRef);
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTBody, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TTBody, "[pTreeTableBody]", never, { "columns": "pTreeTableBody"; "template": "pTreeTableBodyTemplate"; "frozen": "frozen"; }, {}, never, never>;
}
export declare class TTScrollableView implements AfterViewInit, OnDestroy {
    tt: TreeTable;
    el: ElementRef;
    zone: NgZone;
    columns: any[];
    frozen: boolean;
    scrollHeaderViewChild: ElementRef;
    scrollHeaderBoxViewChild: ElementRef;
    scrollBodyViewChild: ElementRef;
    scrollTableViewChild: ElementRef;
    scrollLoadingTableViewChild: ElementRef;
    scrollFooterViewChild: ElementRef;
    scrollFooterBoxViewChild: ElementRef;
    scrollableAlignerViewChild: ElementRef;
    virtualScrollBody: CdkVirtualScrollViewport;
    headerScrollListener: any;
    bodyScrollListener: any;
    footerScrollListener: any;
    frozenSiblingBody: Element;
    totalRecordsSubscription: Subscription;
    _scrollHeight: string;
    preventBodyScrollPropagation: boolean;
    get scrollHeight(): string;
    set scrollHeight(val: string);
    constructor(tt: TreeTable, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindEvents(): void;
    unbindEvents(): void;
    onHeaderScroll(): void;
    onFooterScroll(): void;
    onBodyScroll(event: any): void;
    scrollToVirtualIndex(index: number): void;
    scrollTo(options: any): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTScrollableView, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TTScrollableView, "[ttScrollableView]", never, { "columns": "ttScrollableView"; "frozen": "frozen"; "scrollHeight": "scrollHeight"; }, {}, never, never>;
}
export declare class TTSortableColumn implements OnInit, OnDestroy {
    tt: TreeTable;
    field: string;
    ttSortableColumnDisabled: boolean;
    sorted: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable);
    ngOnInit(): void;
    updateSortState(): void;
    onClick(event: MouseEvent): void;
    onEnterKey(event: MouseEvent): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTSortableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTSortableColumn, "[ttSortableColumn]", never, { "field": "ttSortableColumn"; "ttSortableColumnDisabled": "ttSortableColumnDisabled"; }, {}, never>;
}
export declare class TTSortIcon implements OnInit, OnDestroy {
    tt: TreeTable;
    cd: ChangeDetectorRef;
    field: string;
    ariaLabelDesc: string;
    ariaLabelAsc: string;
    subscription: Subscription;
    sortOrder: number;
    constructor(tt: TreeTable, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: any): void;
    updateSortState(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTSortIcon, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TTSortIcon, "p-treeTableSortIcon", never, { "field": "field"; "ariaLabelDesc": "ariaLabelDesc"; "ariaLabelAsc": "ariaLabelAsc"; }, {}, never, never>;
}
export declare class TTResizableColumn implements AfterViewInit, OnDestroy {
    tt: TreeTable;
    el: ElementRef;
    zone: NgZone;
    ttResizableColumnDisabled: boolean;
    resizer: HTMLSpanElement;
    resizerMouseDownListener: any;
    documentMouseMoveListener: any;
    documentMouseUpListener: any;
    constructor(tt: TreeTable, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindDocumentEvents(): void;
    unbindDocumentEvents(): void;
    onMouseDown(event: Event): void;
    onDocumentMouseMove(event: Event): void;
    onDocumentMouseUp(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTResizableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTResizableColumn, "[ttResizableColumn]", never, { "ttResizableColumnDisabled": "ttResizableColumnDisabled"; }, {}, never>;
}
export declare class TTReorderableColumn implements AfterViewInit, OnDestroy {
    tt: TreeTable;
    el: ElementRef;
    zone: NgZone;
    ttReorderableColumnDisabled: boolean;
    dragStartListener: any;
    dragOverListener: any;
    dragEnterListener: any;
    dragLeaveListener: any;
    mouseDownListener: any;
    constructor(tt: TreeTable, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    bindEvents(): void;
    unbindEvents(): void;
    onMouseDown(event: any): void;
    onDragStart(event: any): void;
    onDragOver(event: any): void;
    onDragEnter(event: any): void;
    onDragLeave(event: any): void;
    onDrop(event: any): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTReorderableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTReorderableColumn, "[ttReorderableColumn]", never, { "ttReorderableColumnDisabled": "ttReorderableColumnDisabled"; }, {}, never>;
}
export declare class TTSelectableRow implements OnInit, OnDestroy {
    tt: TreeTable;
    tableService: TreeTableService;
    rowNode: any;
    ttSelectableRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable, tableService: TreeTableService);
    ngOnInit(): void;
    onClick(event: Event): void;
    onEnterKey(event: KeyboardEvent): void;
    onTouchEnd(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTSelectableRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTSelectableRow, "[ttSelectableRow]", never, { "rowNode": "ttSelectableRow"; "ttSelectableRowDisabled": "ttSelectableRowDisabled"; }, {}, never>;
}
export declare class TTSelectableRowDblClick implements OnInit, OnDestroy {
    tt: TreeTable;
    tableService: TreeTableService;
    rowNode: any;
    ttSelectableRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable, tableService: TreeTableService);
    ngOnInit(): void;
    onClick(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTSelectableRowDblClick, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTSelectableRowDblClick, "[ttSelectableRowDblClick]", never, { "rowNode": "ttSelectableRowDblClick"; "ttSelectableRowDisabled": "ttSelectableRowDisabled"; }, {}, never>;
}
export declare class TTContextMenuRow {
    tt: TreeTable;
    tableService: TreeTableService;
    private el;
    rowNode: any;
    ttContextMenuRowDisabled: boolean;
    selected: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable, tableService: TreeTableService, el: ElementRef);
    onContextMenu(event: Event): void;
    isEnabled(): boolean;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTContextMenuRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTContextMenuRow, "[ttContextMenuRow]", never, { "rowNode": "ttContextMenuRow"; "ttContextMenuRowDisabled": "ttContextMenuRowDisabled"; }, {}, never>;
}
export declare class TTCheckbox {
    tt: TreeTable;
    tableService: TreeTableService;
    cd: ChangeDetectorRef;
    disabled: boolean;
    rowNode: any;
    boxViewChild: ElementRef;
    checked: boolean;
    subscription: Subscription;
    constructor(tt: TreeTable, tableService: TreeTableService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: Event): void;
    onFocus(): void;
    onBlur(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTCheckbox, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TTCheckbox, "p-treeTableCheckbox", never, { "disabled": "disabled"; "rowNode": "value"; }, {}, never, never>;
}
export declare class TTHeaderCheckbox {
    tt: TreeTable;
    tableService: TreeTableService;
    private cd;
    boxViewChild: ElementRef;
    checked: boolean;
    disabled: boolean;
    selectionChangeSubscription: Subscription;
    valueChangeSubscription: Subscription;
    constructor(tt: TreeTable, tableService: TreeTableService, cd: ChangeDetectorRef);
    ngOnInit(): void;
    onClick(event: Event, checked: any): void;
    onFocus(): void;
    onBlur(): void;
    ngOnDestroy(): void;
    updateCheckedState(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTHeaderCheckbox, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TTHeaderCheckbox, "p-treeTableHeaderCheckbox", never, {}, {}, never, never>;
}
export declare class TTEditableColumn implements AfterViewInit {
    tt: TreeTable;
    el: ElementRef;
    zone: NgZone;
    data: any;
    field: any;
    ttEditableColumnDisabled: boolean;
    constructor(tt: TreeTable, el: ElementRef, zone: NgZone);
    ngAfterViewInit(): void;
    onClick(event: MouseEvent): void;
    openCell(): void;
    closeEditingCell(): void;
    onKeyDown(event: KeyboardEvent): void;
    findCell(element: any): any;
    moveToPreviousCell(event: KeyboardEvent): void;
    moveToNextCell(event: KeyboardEvent): void;
    findPreviousEditableColumn(cell: Element): any;
    findNextEditableColumn(cell: Element): any;
    isEnabled(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTEditableColumn, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTEditableColumn, "[ttEditableColumn]", never, { "data": "ttEditableColumn"; "field": "ttEditableColumnField"; "ttEditableColumnDisabled": "ttEditableColumnDisabled"; }, {}, never>;
}
export declare class TreeTableCellEditor implements AfterContentInit {
    tt: TreeTable;
    editableColumn: TTEditableColumn;
    templates: QueryList<PrimeTemplate>;
    inputTemplate: TemplateRef<any>;
    outputTemplate: TemplateRef<any>;
    constructor(tt: TreeTable, editableColumn: TTEditableColumn);
    ngAfterContentInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeTableCellEditor, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TreeTableCellEditor, "p-treeTableCellEditor", never, {}, {}, ["templates"], never>;
}
export declare class TTRow {
    tt: TreeTable;
    el: ElementRef;
    zone: NgZone;
    rowNode: any;
    constructor(tt: TreeTable, el: ElementRef, zone: NgZone);
    onKeyDown(event: KeyboardEvent): void;
    restoreFocus(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TTRow, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TTRow, "[ttRow]", never, { "rowNode": "ttRow"; }, {}, never>;
}
export declare class TreeTableToggler {
    tt: TreeTable;
    rowNode: any;
    constructor(tt: TreeTable);
    onClick(event: Event): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeTableToggler, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TreeTableToggler, "p-treeTableToggler", never, { "rowNode": "rowNode"; }, {}, never, never>;
}
export declare class TreeTableModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<TreeTableModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TreeTableModule, [typeof TreeTable, typeof TreeTableToggler, typeof TTScrollableView, typeof TTBody, typeof TTSortableColumn, typeof TTSortIcon, typeof TTResizableColumn, typeof TTRow, typeof TTReorderableColumn, typeof TTSelectableRow, typeof TTSelectableRowDblClick, typeof TTContextMenuRow, typeof TTCheckbox, typeof TTHeaderCheckbox, typeof TTEditableColumn, typeof TreeTableCellEditor], [typeof i1.CommonModule, typeof i2.PaginatorModule, typeof i3.ScrollingModule, typeof i4.RippleModule], [typeof TreeTable, typeof i5.SharedModule, typeof TreeTableToggler, typeof TTSortableColumn, typeof TTSortIcon, typeof TTResizableColumn, typeof TTRow, typeof TTReorderableColumn, typeof TTSelectableRow, typeof TTSelectableRowDblClick, typeof TTContextMenuRow, typeof TTCheckbox, typeof TTHeaderCheckbox, typeof TTEditableColumn, typeof TreeTableCellEditor, typeof i3.ScrollingModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TreeTableModule>;
}
