import { Directive, Input } from '@angular/core';
export class FaStackItemSizeDirective {
    constructor() {
        /**
         * Specify whether icon inside {@link FaStackComponent} should be rendered in
         * regular size (1x) or as a larger icon (2x).
         */
        this.stackItemSize = '1x';
    }
    ngOnChanges(changes) {
        if ('size' in changes) {
            throw new Error('fa-icon is not allowed to customize size when used inside fa-stack. ' +
                'Set size on the enclosing fa-stack instead: <fa-stack size="4x">...</fa-stack>.');
        }
    }
}
FaStackItemSizeDirective.decorators = [
    { type: Directive, args: [{
                // tslint:disable-next-line:directive-selector
                selector: 'fa-icon[stackItemSize],fa-duotone-icon[stackItemSize]',
            },] }
];
FaStackItemSizeDirective.propDecorators = {
    stackItemSize: [{ type: Input }],
    size: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2staXRlbS1zaXplLmRpcmVjdGl2ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvc3RhY2svc3RhY2staXRlbS1zaXplLmRpcmVjdGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBNEIsTUFBTSxlQUFlLENBQUM7QUFRM0UsTUFBTSxPQUFPLHdCQUF3QjtJQUpyQztRQUtFOzs7V0FHRztRQUNNLGtCQUFhLEdBQWdCLElBQUksQ0FBQztJQWU3QyxDQUFDO0lBUkMsV0FBVyxDQUFDLE9BQXNCO1FBQ2hDLElBQUksTUFBTSxJQUFJLE9BQU8sRUFBRTtZQUNyQixNQUFNLElBQUksS0FBSyxDQUNiLHNFQUFzRTtnQkFDcEUsaUZBQWlGLENBQ3BGLENBQUM7U0FDSDtJQUNILENBQUM7OztZQXZCRixTQUFTLFNBQUM7Z0JBQ1QsOENBQThDO2dCQUM5QyxRQUFRLEVBQUUsdURBQXVEO2FBQ2xFOzs7NEJBTUUsS0FBSzttQkFLTCxLQUFLIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGlyZWN0aXZlLCBJbnB1dCwgT25DaGFuZ2VzLCBTaW1wbGVDaGFuZ2VzIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBTaXplUHJvcCB9IGZyb20gJ0Bmb3J0YXdlc29tZS9mb250YXdlc29tZS1zdmctY29yZSc7XG5pbXBvcnQgeyBGYVN0YWNrQ29tcG9uZW50IH0gZnJvbSAnLi9zdGFjay5jb21wb25lbnQnO1xuXG5ARGlyZWN0aXZlKHtcbiAgLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOmRpcmVjdGl2ZS1zZWxlY3RvclxuICBzZWxlY3RvcjogJ2ZhLWljb25bc3RhY2tJdGVtU2l6ZV0sZmEtZHVvdG9uZS1pY29uW3N0YWNrSXRlbVNpemVdJyxcbn0pXG5leHBvcnQgY2xhc3MgRmFTdGFja0l0ZW1TaXplRGlyZWN0aXZlIGltcGxlbWVudHMgT25DaGFuZ2VzIHtcbiAgLyoqXG4gICAqIFNwZWNpZnkgd2hldGhlciBpY29uIGluc2lkZSB7QGxpbmsgRmFTdGFja0NvbXBvbmVudH0gc2hvdWxkIGJlIHJlbmRlcmVkIGluXG4gICAqIHJlZ3VsYXIgc2l6ZSAoMXgpIG9yIGFzIGEgbGFyZ2VyIGljb24gKDJ4KS5cbiAgICovXG4gIEBJbnB1dCgpIHN0YWNrSXRlbVNpemU6ICcxeCcgfCAnMngnID0gJzF4JztcblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBASW5wdXQoKSBzaXplPzogU2l6ZVByb3A7XG5cbiAgbmdPbkNoYW5nZXMoY2hhbmdlczogU2ltcGxlQ2hhbmdlcykge1xuICAgIGlmICgnc2l6ZScgaW4gY2hhbmdlcykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnZmEtaWNvbiBpcyBub3QgYWxsb3dlZCB0byBjdXN0b21pemUgc2l6ZSB3aGVuIHVzZWQgaW5zaWRlIGZhLXN0YWNrLiAnICtcbiAgICAgICAgICAnU2V0IHNpemUgb24gdGhlIGVuY2xvc2luZyBmYS1zdGFjayBpbnN0ZWFkOiA8ZmEtc3RhY2sgc2l6ZT1cIjR4XCI+Li4uPC9mYS1zdGFjaz4uJyxcbiAgICAgICk7XG4gICAgfVxuICB9XG59XG4iXX0=