function ZIndexUtils() {
    let zIndexes = [];
    const generateZIndex = (key, baseZIndex) => {
        let lastZIndex = zIndexes.length > 0 ? zIndexes[zIndexes.length - 1] : { key, value: baseZIndex };
        let newZIndex = lastZIndex.value + (lastZIndex.key === key ? 0 : baseZIndex) + 1;
        zIndexes.push({ key, value: newZIndex });
        return newZIndex;
    };
    const revertZIndex = (zIndex) => {
        zIndexes = zIndexes.filter(obj => obj.value !== zIndex);
    };
    const getCurrentZIndex = () => {
        return zIndexes.length > 0 ? zIndexes[zIndexes.length - 1].value : 0;
    };
    const getZIndex = (el) => {
        return el ? parseInt(el.style.zIndex, 10) || 0 : 0;
    };
    return {
        get: getZIndex,
        set: (key, el, baseZIndex) => {
            if (el) {
                el.style.zIndex = String(generateZIndex(key, baseZIndex));
            }
        },
        clear: (el) => {
            if (el) {
                revertZIndex(getZIndex(el));
                el.style.zIndex = '';
            }
        },
        getCurrent: () => getCurrentZIndex()
    };
}
export default ZIndexUtils();
//# sourceMappingURL=data:application/json;base64,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