import { ElementRef, AfterContentInit, AfterViewChecked, QueryList, TemplateRef, EventEmitter, ChangeDetectorRef } from '@angular/core';
import { FilterService } from 'primeng/api';
import { CdkDragDrop } from '@angular/cdk/drag-drop';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/button";
import * as i3 from "primeng/api";
import * as i4 from "primeng/ripple";
import * as i5 from "@angular/cdk/drag-drop";
export declare class PickList implements AfterViewChecked, AfterContentInit {
    el: ElementRef;
    cd: ChangeDetectorRef;
    filterService: FilterService;
    source: any[];
    target: any[];
    sourceHeader: string;
    rightButtonAriaLabel: string;
    leftButtonAriaLabel: string;
    allRightButtonAriaLabel: string;
    allLeftButtonAriaLabel: string;
    upButtonAriaLabel: string;
    downButtonAriaLabel: string;
    topButtonAriaLabel: string;
    bottomButtonAriaLabel: string;
    targetHeader: string;
    responsive: boolean;
    filterBy: string;
    filterLocale: string;
    trackBy: Function;
    sourceTrackBy: Function;
    targetTrackBy: Function;
    showSourceFilter: boolean;
    showTargetFilter: boolean;
    metaKeySelection: boolean;
    dragdrop: boolean;
    style: any;
    styleClass: string;
    sourceStyle: any;
    targetStyle: any;
    showSourceControls: boolean;
    showTargetControls: boolean;
    sourceFilterPlaceholder: string;
    targetFilterPlaceholder: string;
    disabled: boolean;
    ariaSourceFilterLabel: string;
    ariaTargetFilterLabel: string;
    filterMatchMode: string;
    breakpoint: string;
    onMoveToSource: EventEmitter<any>;
    onMoveAllToSource: EventEmitter<any>;
    onMoveAllToTarget: EventEmitter<any>;
    onMoveToTarget: EventEmitter<any>;
    onSourceReorder: EventEmitter<any>;
    onTargetReorder: EventEmitter<any>;
    onSourceSelect: EventEmitter<any>;
    onTargetSelect: EventEmitter<any>;
    onSourceFilter: EventEmitter<any>;
    onTargetFilter: EventEmitter<any>;
    listViewSourceChild: ElementRef;
    listViewTargetChild: ElementRef;
    sourceFilterViewChild: ElementRef;
    targetFilterViewChild: ElementRef;
    templates: QueryList<any>;
    itemTemplate: TemplateRef<any>;
    visibleOptionsSource: any[];
    visibleOptionsTarget: any[];
    selectedItemsSource: any[];
    selectedItemsTarget: any[];
    reorderedListElement: any;
    movedUp: boolean;
    movedDown: boolean;
    itemTouched: boolean;
    styleElement: any;
    id: string;
    filterValueSource: string;
    filterValueTarget: string;
    fromListType: number;
    emptyMessageSourceTemplate: TemplateRef<any>;
    emptyFilterMessageSourceTemplate: TemplateRef<any>;
    emptyMessageTargetTemplate: TemplateRef<any>;
    emptyFilterMessageTargetTemplate: TemplateRef<any>;
    sourceHeaderTemplate: TemplateRef<any>;
    targetHeaderTemplate: TemplateRef<any>;
    readonly SOURCE_LIST = -1;
    readonly TARGET_LIST = 1;
    constructor(el: ElementRef, cd: ChangeDetectorRef, filterService: FilterService);
    ngOnInit(): void;
    ngAfterContentInit(): void;
    ngAfterViewChecked(): void;
    onItemClick(event: any, item: any, selectedItems: any[], callback: EventEmitter<any>): void;
    onSourceItemDblClick(): void;
    onTargetItemDblClick(): void;
    onFilter(event: KeyboardEvent, data: any[], listType: number): void;
    filter(data: any[], listType: number): void;
    isItemVisible(item: any, listType: number): boolean;
    isEmpty(listType: number): boolean;
    isVisibleInList(data: any[], item: any, filterValue: string): boolean;
    onItemTouchEnd(): void;
    private sortByIndexInList;
    moveUp(listElement: any, list: any, selectedItems: any, callback: any, listType: any): void;
    moveTop(listElement: any, list: any, selectedItems: any, callback: any, listType: any): void;
    moveDown(listElement: any, list: any, selectedItems: any, callback: any, listType: any): void;
    moveBottom(listElement: any, list: any, selectedItems: any, callback: any, listType: any): void;
    moveRight(): void;
    moveAllRight(): void;
    moveLeft(): void;
    moveAllLeft(): void;
    isSelected(item: any, selectedItems: any[]): boolean;
    findIndexInSelection(item: any, selectedItems: any[]): number;
    onDrop(event: CdkDragDrop<string[]>, listType: number): void;
    getDropIndexes(fromIndex: any, toIndex: any, droppedList: any, isTransfer: any, data: any): {
        previousIndex: any;
        currentIndex: any;
    };
    findFilteredCurrentIndex(visibleOptions: any, index: any, options: any): number;
    resetFilter(): void;
    onItemKeydown(event: KeyboardEvent, item: any, selectedItems: any[], callback: EventEmitter<any>): void;
    findNextItem(item: any): any;
    findPrevItem(item: any): any;
    createStyle(): void;
    destroyStyle(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<PickList, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PickList, "p-pickList", never, { "source": "source"; "target": "target"; "sourceHeader": "sourceHeader"; "rightButtonAriaLabel": "rightButtonAriaLabel"; "leftButtonAriaLabel": "leftButtonAriaLabel"; "allRightButtonAriaLabel": "allRightButtonAriaLabel"; "allLeftButtonAriaLabel": "allLeftButtonAriaLabel"; "upButtonAriaLabel": "upButtonAriaLabel"; "downButtonAriaLabel": "downButtonAriaLabel"; "topButtonAriaLabel": "topButtonAriaLabel"; "bottomButtonAriaLabel": "bottomButtonAriaLabel"; "targetHeader": "targetHeader"; "responsive": "responsive"; "filterBy": "filterBy"; "filterLocale": "filterLocale"; "trackBy": "trackBy"; "sourceTrackBy": "sourceTrackBy"; "targetTrackBy": "targetTrackBy"; "showSourceFilter": "showSourceFilter"; "showTargetFilter": "showTargetFilter"; "metaKeySelection": "metaKeySelection"; "dragdrop": "dragdrop"; "style": "style"; "styleClass": "styleClass"; "sourceStyle": "sourceStyle"; "targetStyle": "targetStyle"; "showSourceControls": "showSourceControls"; "showTargetControls": "showTargetControls"; "sourceFilterPlaceholder": "sourceFilterPlaceholder"; "targetFilterPlaceholder": "targetFilterPlaceholder"; "disabled": "disabled"; "ariaSourceFilterLabel": "ariaSourceFilterLabel"; "ariaTargetFilterLabel": "ariaTargetFilterLabel"; "filterMatchMode": "filterMatchMode"; "breakpoint": "breakpoint"; }, { "onMoveToSource": "onMoveToSource"; "onMoveAllToSource": "onMoveAllToSource"; "onMoveAllToTarget": "onMoveAllToTarget"; "onMoveToTarget": "onMoveToTarget"; "onSourceReorder": "onSourceReorder"; "onTargetReorder": "onTargetReorder"; "onSourceSelect": "onSourceSelect"; "onTargetSelect": "onTargetSelect"; "onSourceFilter": "onSourceFilter"; "onTargetFilter": "onTargetFilter"; }, ["templates"], never>;
}
export declare class PickListModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<PickListModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<PickListModule, [typeof PickList], [typeof i1.CommonModule, typeof i2.ButtonModule, typeof i3.SharedModule, typeof i4.RippleModule, typeof i5.DragDropModule], [typeof PickList, typeof i3.SharedModule, typeof i5.DragDropModule]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<PickListModule>;
}
