import { ElementRef, AfterViewInit, OnDestroy, NgZone, SimpleChanges } from '@angular/core';
import { PrimeNGConfig } from 'primeng/api';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
export interface TooltipOptions {
    tooltipLabel?: string;
    tooltipPosition?: string;
    tooltipEvent?: string;
    appendTo?: any;
    positionStyle?: string;
    tooltipStyleClass?: string;
    tooltipZIndex?: string;
    escape?: boolean;
    disabled?: boolean;
    showDelay?: number;
    hideDelay?: number;
    positionTop?: number;
    positionLeft?: number;
    life?: number;
}
export declare class Tooltip implements AfterViewInit, OnDestroy {
    el: ElementRef;
    zone: NgZone;
    config: PrimeNGConfig;
    tooltipPosition: string;
    tooltipEvent: string;
    appendTo: any;
    positionStyle: string;
    tooltipStyleClass: string;
    tooltipZIndex: string;
    escape: boolean;
    showDelay: number;
    hideDelay: number;
    life: number;
    positionTop: number;
    positionLeft: number;
    text: string;
    get disabled(): boolean;
    set disabled(val: boolean);
    tooltipOptions: TooltipOptions;
    _tooltipOptions: TooltipOptions;
    _disabled: boolean;
    container: any;
    styleClass: string;
    tooltipText: any;
    showTimeout: any;
    hideTimeout: any;
    active: boolean;
    mouseEnterListener: Function;
    mouseLeaveListener: Function;
    clickListener: Function;
    focusListener: Function;
    blurListener: Function;
    scrollHandler: any;
    resizeListener: any;
    constructor(el: ElementRef, zone: NgZone, config: PrimeNGConfig);
    ngAfterViewInit(): void;
    ngOnChanges(simpleChange: SimpleChanges): void;
    onMouseEnter(e: Event): void;
    onMouseLeave(e: Event): void;
    onFocus(e: Event): void;
    onBlur(e: Event): void;
    onClick(e: Event): void;
    activate(): void;
    deactivate(): void;
    create(): void;
    show(): void;
    hide(): void;
    updateText(): void;
    align(): void;
    getHostOffset(): {
        left: any;
        top: any;
    };
    alignRight(): void;
    alignLeft(): void;
    alignTop(): void;
    alignBottom(): void;
    setOption(option: TooltipOptions): void;
    getOption(option: string): any;
    preAlign(position: string): void;
    isOutOfBounds(): boolean;
    onWindowResize(e: Event): void;
    bindDocumentResizeListener(): void;
    unbindDocumentResizeListener(): void;
    bindScrollListener(): void;
    unbindScrollListener(): void;
    unbindEvents(): void;
    remove(): void;
    clearShowTimeout(): void;
    clearHideTimeout(): void;
    clearTimeouts(): void;
    ngOnDestroy(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<Tooltip, never>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<Tooltip, "[pTooltip]", never, { "tooltipPosition": "tooltipPosition"; "tooltipEvent": "tooltipEvent"; "appendTo": "appendTo"; "positionStyle": "positionStyle"; "tooltipStyleClass": "tooltipStyleClass"; "tooltipZIndex": "tooltipZIndex"; "escape": "escape"; "showDelay": "showDelay"; "hideDelay": "hideDelay"; "life": "life"; "positionTop": "positionTop"; "positionLeft": "positionLeft"; "text": "pTooltip"; "disabled": "tooltipDisabled"; "tooltipOptions": "tooltipOptions"; }, {}, never>;
}
export declare class TooltipModule {
    static ɵfac: i0.ɵɵFactoryDeclaration<TooltipModule, never>;
    static ɵmod: i0.ɵɵNgModuleDeclaration<TooltipModule, [typeof Tooltip], [typeof i1.CommonModule], [typeof Tooltip]>;
    static ɵinj: i0.ɵɵInjectorDeclaration<TooltipModule>;
}
