/*!
 * AngularJS Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.2.2-master-0a06f99
 */
function MdDialogDirective(e,t,i){return{restrict:"E",link:function(o,a){a.addClass("_md"),t(a),e(function(){var e,t=a[0].querySelector("md-dialog-content");function n(){a.toggleClass("md-content-overflow",t.scrollHeight>t.clientHeight)}t&&(e=t.getElementsByTagName("img"),n(),angular.element(e).on("load",n)),o.$on("$destroy",function(){i.destroy(a)})})}}}function MdDialogProvider(e){var v,b,C;return n.$inject=["$mdDialog","$mdConstant"],o.$inject=["$mdDialog","$mdAria","$mdUtil","$mdConstant","$animate","$document","$window","$rootElement","$log","$injector","$mdTheming","$interpolate","$mdInteraction"],e("$mdDialog").setDefaults({methods:["disableParentScroll","hasBackdrop","clickOutsideToClose","escapeToClose","targetEvent","closeTo","openFrom","parent","fullscreen","multiple"],options:o}).addPreset("alert",{methods:["title","htmlContent","textContent","ariaLabel","ok","theme","css"],options:t}).addPreset("confirm",{methods:["title","htmlContent","textContent","ariaLabel","ok","cancel","theme","css"],options:t}).addPreset("prompt",{methods:["title","htmlContent","textContent","initialValue","placeholder","ariaLabel","ok","cancel","theme","css","required"],options:t});function t(){return{template:['<md-dialog md-theme="{{ dialog.theme || dialog.defaultTheme }}" aria-label="{{ dialog.ariaLabel }}" ng-class="dialog.css">','  <md-dialog-content class="md-dialog-content" role="document" tabIndex="-1">','    <h2 class="md-title">{{ dialog.title }}</h2>','    <div ng-if="::dialog.mdHtmlContent" class="md-dialog-content-body" ','        ng-bind-html="::dialog.mdHtmlContent"></div>','    <div ng-if="::!dialog.mdHtmlContent" class="md-dialog-content-body">',"      <p>{{::dialog.mdTextContent}}</p>","    </div>",'    <md-input-container md-no-float ng-if="::dialog.$type == \'prompt\'" class="md-prompt-input-container">','      <input ng-keypress="dialog.keypress($event)" md-autofocus ng-model="dialog.result"              placeholder="{{::dialog.placeholder}}" ng-required="dialog.required">',"    </md-input-container>","  </md-dialog-content>","  <md-dialog-actions>",'    <md-button ng-if="dialog.$type === \'confirm\' || dialog.$type === \'prompt\'"               ng-click="dialog.abort()" class="md-primary md-cancel-button">',"      {{ dialog.cancel }}","    </md-button>",'    <md-button ng-click="dialog.hide()" class="md-primary md-confirm-button" md-autofocus="dialog.$type===\'alert\'"               ng-disabled="dialog.required && !dialog.result">',"      {{ dialog.ok }}","    </md-button>","  </md-dialog-actions>","</md-dialog>"].join("").replace(/\s\s+/g,""),controller:n,controllerAs:"dialog",bindToController:!0}}function n(o,a){this.$onInit=function(){var n="prompt"===this.$type;n&&this.initialValue&&(this.result=this.initialValue),this.hide=function(){o.hide(!n||this.result)},this.abort=function(){o.cancel()},this.keypress=function(e){var t=n&&this.required&&!angular.isDefined(this.result);e.keyCode!==a.KEY_CODE.ENTER||t||o.hide(this.result)}}}function o(m,l,g,f,a,d,p,i,r,s,t,c,u){return{hasBackdrop:!0,isolateScope:!0,onCompiling:function(e){e.defaultTheme=t.defaultTheme(),function(t){var e;t.targetEvent&&t.targetEvent.target&&(e=angular.element(t.targetEvent.target));var n=e&&e.controller("mdTheme");if(t.hasTheme=!!n,!t.hasTheme)return;t.themeWatch=n.$shouldWatch;var o=t.theme||n.$mdTheme;o&&(t.scope.theme=o);var a=n.registerChanges(function(e){t.scope.theme=e,t.themeWatch||a()})}(e)},onShow:function(e,t,n){angular.element(d[0].body).addClass("md-dialog-is-showing");var o=t.find("md-dialog");if(o.hasClass("ng-cloak")){r.warn("$mdDialog: using `<md-dialog ng-cloak>` will affect the dialog opening animations.",t[0])}return function(e){e.origin=angular.extend({element:null,bounds:null,focus:angular.noop},e.origin||{}),e.parent=n(e.parent,i),e.closeTo=t(n(e.closeTo)),e.openFrom=t(n(e.openFrom)),e.targetEvent&&(e.origin=t(e.targetEvent.target,e.origin),e.originInteraction=u.getLastInteractionType());function t(e,t){var n=angular.element(e||{});if(n&&n.length){var o=angular.isFunction(n[0].getBoundingClientRect);return angular.extend(t||{},{element:o?n:void 0,bounds:o?n[0].getBoundingClientRect():angular.extend({},{top:0,left:0,height:0,width:0},n[0]),focus:angular.bind(n,n.focus)})}}function n(e,t){return angular.isString(e)&&(e=d[0].querySelector(e)),angular.element(e||t)}}(n),function(n,t){var e="alert"===t.$type?"alertdialog":"dialog",o=n.find("md-dialog-content"),a=n.attr("id"),i="dialogContent_"+(a||g.nextUid());n.attr({role:e,tabIndex:"-1"}),0===o.length&&(o=n,a&&(i=a));o.attr("id",i),n.attr("aria-describedby",i),t.ariaLabel?l.expect(n,"aria-label",t.ariaLabel):l.expectAsync(n,"aria-label",function(){if(t.title)return t.title;var e=o.text().split(/\s+/);return 3<e.length&&(e=e.slice(0,3).concat("...")),e.join(" ")});(v=document.createElement("div")).classList.add("md-dialog-focus-trap"),v.tabIndex=0,b=v.cloneNode(!1);function r(e){if(e.target&&e.target.nextSibling&&"MD-DIALOG"===e.target.nextSibling.nodeName){var t=g.getLastTabbableElement(n[0]);angular.isElement(t)&&t.focus()}else n.focus()}v.addEventListener("focus",r),b.addEventListener("focus",r),C=function(){v.removeEventListener("focus",r),b.removeEventListener("focus",r),v&&v.parentNode&&v.parentNode.removeChild(v),b&&b.parentNode&&b.parentNode.removeChild(b)},n[0].parentNode.insertBefore(v,n[0]),n.after(b)}(o,n),function(e,t,n){n.disableParentScroll&&(n.restoreScroll=g.disableScrollAround(t,n.parent));n.hasBackdrop&&(n.backdrop=g.createBackdrop(e,"md-dialog-backdrop md-opaque"),a.enter(n.backdrop,n.parent));n.hideBackdrop=function(e){n.backdrop&&(e?n.backdrop.remove():a.leave(n.backdrop)),n.disableParentScroll&&(n.restoreScroll&&n.restoreScroll(),delete n.restoreScroll),n.hideBackdrop=null}}(e,t,n),function(e,t){function n(){var e="alert"===t.$type?m.hide:m.cancel;g.nextTick(e,!0)}var o=angular.element(p),a=g.debounce(function(){h(e,t)},60),i=[];if(t.escapeToClose){function r(e){e.keyCode===f.KEY_CODE.ESCAPE&&(e.stopImmediatePropagation(),e.preventDefault(),n())}var l=t.parent;e.on("keydown",r),l.on("keydown",r),i.push(function(){e.off("keydown",r),l.off("keydown",r)})}if(o.on("resize",a),i.push(function(){o.off("resize",a)}),t.clickOutsideToClose){function d(e){c=e.target}function s(e){c===u[0]&&e.target===u[0]&&(e.stopPropagation(),e.preventDefault(),n())}var c,u=e;u.on("mousedown",d),u.on("mouseup",s),i.push(function(){u.off("mousedown",d),u.off("mouseup",s)})}t.deactivateListeners=function(){i.forEach(function(e){e()}),t.deactivateListeners=null}}(t,n),function(e,t){t.parent.append(e),t.reverseContainerStretch=h(e,t);var n=e.find("md-dialog"),o=g.dom.animator,a=o.calculateZoomToOrigin,i={transitionInClass:"md-transition-in",transitionOutClass:"md-transition-out"},r=o.toTransformCss(a(n,t.openFrom||t.origin)),l=o.toTransformCss("");return n.toggleClass("md-dialog-fullscreen",!!t.fullscreen),o.translate3d(n,r,l,i).then(function(e){return t.reverseAnimate=function(){return delete t.reverseAnimate,t.closeTo?(i={transitionInClass:"md-transition-out",transitionOutClass:"md-transition-in"},r=l,l=o.toTransformCss(a(n,t.closeTo)),o.translate3d(n,r,l,i)):e(l=o.toTransformCss(a(n,t.origin)))},t.clearAnimate=function(){return delete t.clearAnimate,n.removeClass([i.transitionOutClass,i.transitionInClass].join(" ")),o.translate3d(n,l,o.toTransformCss(""),{})},!0})}(t,n).then(function(){!function(e,t){var o=!0;function n(e){for(var t=function(e){for(var t,n=[];e.parentNode;){if(e===document.body)return n;for(var o=e.parentNode.children,a=0;a<o.length;a++)e===o[a]||(t=o[a],-1!==["SCRIPT","STYLE"].indexOf(t.nodeName))||o[a].hasAttribute("aria-live")||n.push(o[a]);e=e.parentNode}return n}(e),n=0;n<t.length;n++)t[n].setAttribute("aria-hidden",o)}n(e[0]),t.unlockScreenReader=function(){o=!1,n(e[0]),t.unlockScreenReader=null}}(t,n),function(){if(n.focusOnOpen){(g.findFocusTarget(t)||t[0].querySelector(".dialog-close, md-dialog-actions button:last-child")||o).focus()}}()})},onShowing:function(e,t,n,o){if(o){var a=o.htmlContent||n.htmlContent||"",i=o.textContent||n.textContent||"";if(a&&!s.has("$sanitize"))throw Error("The ngSanitize module must be loaded in order to use htmlContent.");if(a&&i)throw Error("md-dialog cannot have both `htmlContent` and `textContent`");o.mdHtmlContent=a,o.mdTextContent=i}},onRemove:function(e,t,n){n.deactivateListeners(),n.unlockScreenReader(),n.hideBackdrop(n.$destroy),C&&(C(),C=null);return n.$destroy?o():function(e,t){return t.reverseAnimate().then(function(){t.contentElement&&t.clearAnimate()})}(0,n).then(o);function o(){angular.element(d[0].body).removeClass("md-dialog-is-showing"),n.contentElement&&n.reverseContainerStretch(),n.cleanupElement(),n.$destroy||"keyboard"!==n.originInteraction||n.origin.focus()}},clickOutsideToClose:!1,escapeToClose:!0,targetEvent:null,closeTo:null,openFrom:null,focusOnOpen:!0,disableParentScroll:!0,autoWrap:!0,fullscreen:!1,transformTemplate:function(e,t){var n,o=c.startSymbol(),a=c.endSymbol(),i=o+(t.themeWatch?"":"::")+"theme"+a;return'<div class="md-dialog-container" tabindex="-1" '+(t.hasTheme?'md-theme="'+i+'"':"")+">"+(n=e,t.autoWrap&&!/<\/md-dialog>/g.test(n)?"<md-dialog>"+(n||"")+"</md-dialog>":n||"")+"</div>"}};function h(e,t){var n="fixed"===p.getComputedStyle(d[0].body).position,o=t.backdrop?p.getComputedStyle(t.backdrop[0]):null,a=o?Math.min(d[0].body.clientHeight,Math.ceil(Math.abs(parseInt(o.height,10)))):0,i={top:e.css("top"),height:e.css("height")},r=Math.abs(t.parent[0].getBoundingClientRect().top);return e.css({top:(n?r:0)+"px",height:a?a+"px":"100%"}),function(){e.css(i)}}}}goog.provide("ngmaterial.components.dialog"),goog.require("ngmaterial.components.backdrop"),goog.require("ngmaterial.core"),MdDialogDirective.$inject=["$$rAF","$mdTheming","$mdDialog"],MdDialogProvider.$inject=["$$interimElementProvider"],angular.module("material.components.dialog",["material.core","material.components.backdrop"]).directive("mdDialog",MdDialogDirective).provider("$mdDialog",MdDialogProvider),ngmaterial.components.dialog=angular.module("material.components.dialog");