/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
let testGlobals;
// We check the Node-specific `global` first, because tools tend to add a fake
// `window` in Node environments which won't actually receive global variables.
if (typeof global !== 'undefined') {
    testGlobals = global;
}
else if (typeof window !== 'undefined') {
    testGlobals = window;
}
else {
    testGlobals = {};
}
/** Gets whether the code is currently running in a test environment. */
export function _isTestEnvironment() {
    return (typeof testGlobals.__karma__ !== 'undefined' && !!testGlobals.__karma__) ||
        (typeof testGlobals.jasmine !== 'undefined' && !!testGlobals.jasmine) ||
        (typeof testGlobals.jest !== 'undefined' && !!testGlobals.jest) ||
        (typeof testGlobals.Mocha !== 'undefined' && !!testGlobals.Mocha);
}
//# sourceMappingURL=data:application/json;base64,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