import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Injectable } from "@angular/core";
import { Observable } from "rxjs";
import { PlannerDto } from "../_models/dto/plannerDto";
import { PlannerLocationDto } from "../_models/dto/plannerLocationDto";
import { Planner } from "../_models/planner";

@Injectable({
    providedIn: 'root'
})
export class PlannerService {

    httpHeaders: HttpHeaders = new HttpHeaders({
        'Authorization': '' + sessionStorage.getItem("token"),
        'Accept': 'application/json',
        'Content-Type': 'application/json'
    });

    constructor(private httpClient: HttpClient) {
    }


    getAllPlanners(): Observable<Planner[]> {
        let url = "http://localhost:8080/api/planners/user";
        console.log("SERVID: " + sessionStorage.getItem("token"));
        console.log(this.httpHeaders.get('Authorization'));
        return this.httpClient.get<Planner[]>(url, { headers: this.httpHeaders });
    }

    postInitialPlanner(plannerDto: PlannerDto): Observable<Planner> {
        let url = "http://localhost:8080/api/planner/new";
        return this.httpClient.post<Planner>(url, plannerDto, {headers: this.httpHeaders});
    }

    updatePlanner(id: number, plannerDto: PlannerDto): Observable<Planner> {
        let url = "http://localhost:8080/api/edit/planner/" + id;
        return this.httpClient.put<Planner>(url, plannerDto, { headers: this.httpHeaders });
    }

    getPlannerById(id: number): Observable<Planner> {
        let url = "http://localhost:8080/api/planner/" + id;
        return this.httpClient.get<Planner>(url);
    }

    deletePlannerById(id: number): Observable<Planner> {
        let url = "http://localhost:8080/api/delete/" + id;
        return this.httpClient.delete<Planner>(url, { headers: this.httpHeaders });
    }

    deleteLocationFromPlanner(plannerLocationDto : PlannerLocationDto) {
        let url = "http://localhost:8080/api/delete-location";
        const options = {
            body: {
                "plannerId": plannerLocationDto.plannerId, 
                "locationId": plannerLocationDto.locationId
            } 
        }
        return this.httpClient.request('delete', url, options);
    }
 

}