/**
 * @license Angular v12.2.13
 * (c) 2010-2021 Google LLC. https://angular.io/
 * License: MIT
 */

import { AnimationBuilder } from '@angular/animations';
import { AnimationDriver } from '@angular/animations/browser';
import { AnimationFactory } from '@angular/animations';
import { AnimationMetadata } from '@angular/animations';
import { AnimationOptions } from '@angular/animations';
import { AnimationPlayer } from '@angular/animations';
import { InjectionToken } from '@angular/core';
import { ModuleWithProviders } from '@angular/core';
import { NgZone } from '@angular/core';
import { OnDestroy } from '@angular/core';
import { Provider } from '@angular/core';
import { Renderer2 } from '@angular/core';
import { RendererFactory2 } from '@angular/core';
import { RendererStyleFlags2 } from '@angular/core';
import { RendererType2 } from '@angular/core';
import { ɵAnimationEngine } from '@angular/animations/browser';
import { ɵAnimationStyleNormalizer } from '@angular/animations/browser';
import { ɵCssKeyframesDriver } from '@angular/animations/browser';
import { ɵDomRendererFactory2 } from '@angular/platform-browser';
import { ɵWebAnimationsDriver } from '@angular/animations/browser';
import { ɵWebAnimationsStyleNormalizer } from '@angular/animations/browser';

/**
 * @publicApi
 */
import * as ɵngcc0 from '@angular/core';
import * as ɵngcc1 from '@angular/platform-browser';
export declare const ANIMATION_MODULE_TYPE: InjectionToken<"NoopAnimations" | "BrowserAnimations">;

/**
 * Exports `BrowserModule` with additional [dependency-injection providers](guide/glossary#provider)
 * for use with animations. See [Animations](guide/animations).
 * @publicApi
 */
export declare class BrowserAnimationsModule {
    /**
     * Configures the module based on the specified object.
     *
     * @param config Object used to configure the behavior of the `BrowserAnimationsModule`.
     * @see `BrowserAnimationsModuleConfig`
     *
     * @usageNotes
     * When registering the `BrowserAnimationsModule`, you can use the `withConfig`
     * function as follows:
     * ```
     * @NgModule({
     *   imports: [BrowserAnimationsModule.withConfig(config)]
     * })
     * class MyNgModule {}
     * ```
     */
    static withConfig(config: BrowserAnimationsModuleConfig): ModuleWithProviders<BrowserAnimationsModule>;
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<BrowserAnimationsModule, never>;
    static ɵmod: ɵngcc0.ɵɵNgModuleDeclaration<BrowserAnimationsModule, never, never, [typeof ɵngcc1.BrowserModule]>;
    static ɵinj: ɵngcc0.ɵɵInjectorDeclaration<BrowserAnimationsModule>;
}

/**
 * Object used to configure the behavior of {@link BrowserAnimationsModule}
 * @publicApi
 */
export declare interface BrowserAnimationsModuleConfig {
    /**
     *  Whether animations should be disabled. Passing this is identical to providing the
     * `NoopAnimationsModule`, but it can be controlled based on a runtime value.
     */
    disableAnimations?: boolean;
}

/**
 * A null player that must be imported to allow disabling of animations.
 * @publicApi
 */
export declare class NoopAnimationsModule {
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<NoopAnimationsModule, never>;
    static ɵmod: ɵngcc0.ɵɵNgModuleDeclaration<NoopAnimationsModule, never, never, [typeof ɵngcc1.BrowserModule]>;
    static ɵinj: ɵngcc0.ɵɵInjectorDeclaration<NoopAnimationsModule>;
}

export declare function ɵangular_packages_platform_browser_animations_animations_a(): ɵWebAnimationsDriver | ɵCssKeyframesDriver;

export declare function ɵangular_packages_platform_browser_animations_animations_b(): ɵWebAnimationsStyleNormalizer;

export declare function ɵangular_packages_platform_browser_animations_animations_c(renderer: ɵDomRendererFactory2, engine: ɵAnimationEngine, zone: NgZone): ɵAnimationRendererFactory;

/**
 * Separate providers from the actual module so that we can do a local modification in Google3 to
 * include them in the BrowserModule.
 */
export declare const ɵangular_packages_platform_browser_animations_animations_d: Provider[];

/**
 * Separate providers from the actual module so that we can do a local modification in Google3 to
 * include them in the BrowserTestingModule.
 */
export declare const ɵangular_packages_platform_browser_animations_animations_e: Provider[];

export declare class ɵangular_packages_platform_browser_animations_animations_f implements Renderer2 {
    protected namespaceId: string;
    delegate: Renderer2;
    engine: ɵAnimationEngine;
    constructor(namespaceId: string, delegate: Renderer2, engine: ɵAnimationEngine);
    get data(): {
        [key: string]: any;
    };
    destroyNode: ((n: any) => void) | null;
    destroy(): void;
    createElement(name: string, namespace?: string | null | undefined): any;
    createComment(value: string): any;
    createText(value: string): any;
    appendChild(parent: any, newChild: any): void;
    insertBefore(parent: any, newChild: any, refChild: any, isMove?: boolean): void;
    removeChild(parent: any, oldChild: any, isHostElement: boolean): void;
    selectRootElement(selectorOrNode: any, preserveContent?: boolean): any;
    parentNode(node: any): any;
    nextSibling(node: any): any;
    setAttribute(el: any, name: string, value: string, namespace?: string | null | undefined): void;
    removeAttribute(el: any, name: string, namespace?: string | null | undefined): void;
    addClass(el: any, name: string): void;
    removeClass(el: any, name: string): void;
    setStyle(el: any, style: string, value: any, flags?: RendererStyleFlags2 | undefined): void;
    removeStyle(el: any, style: string, flags?: RendererStyleFlags2 | undefined): void;
    setProperty(el: any, name: string, value: any): void;
    setValue(node: any, value: string): void;
    listen(target: any, eventName: string, callback: (event: any) => boolean | void): () => void;
    protected disableAnimations(element: any, value: boolean): void;
}

export declare class ɵAnimationRenderer extends ɵangular_packages_platform_browser_animations_animations_f implements Renderer2 {
    factory: ɵAnimationRendererFactory;
    constructor(factory: ɵAnimationRendererFactory, namespaceId: string, delegate: Renderer2, engine: ɵAnimationEngine);
    setProperty(el: any, name: string, value: any): void;
    listen(target: 'window' | 'document' | 'body' | any, eventName: string, callback: (event: any) => any): () => void;
}

export declare class ɵAnimationRendererFactory implements RendererFactory2 {
    private delegate;
    private engine;
    private _zone;
    private _currentId;
    private _microtaskId;
    private _animationCallbacksBuffer;
    private _rendererCache;
    private _cdRecurDepth;
    private promise;
    constructor(delegate: RendererFactory2, engine: ɵAnimationEngine, _zone: NgZone);
    createRenderer(hostElement: any, type: RendererType2): Renderer2;
    begin(): void;
    private _scheduleCountTask;
    end(): void;
    whenRenderingDone(): Promise<any>;
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<ɵAnimationRendererFactory, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDeclaration<ɵAnimationRendererFactory>;
}

export declare class ɵBrowserAnimationBuilder extends AnimationBuilder {
    private _nextAnimationId;
    private _renderer;
    constructor(rootRenderer: RendererFactory2, doc: any);
    build(animation: AnimationMetadata | AnimationMetadata[]): AnimationFactory;
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<ɵBrowserAnimationBuilder, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDeclaration<ɵBrowserAnimationBuilder>;
}

export declare class ɵBrowserAnimationFactory extends AnimationFactory {
    private _id;
    private _renderer;
    constructor(_id: string, _renderer: ɵAnimationRenderer);
    create(element: any, options?: AnimationOptions): AnimationPlayer;
}

export declare class ɵInjectableAnimationEngine extends ɵAnimationEngine implements OnDestroy {
    constructor(doc: any, driver: AnimationDriver, normalizer: ɵAnimationStyleNormalizer);
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDeclaration<ɵInjectableAnimationEngine, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDeclaration<ɵInjectableAnimationEngine>;
}

export { }

//# sourceMappingURL=animations.d.ts.map