package com.example.rezevirajmasa.demo.dto;

import com.example.rezevirajmasa.demo.model.PreorderedItem;
import com.example.rezevirajmasa.demo.model.Reservation;
import com.example.rezevirajmasa.demo.model.Restaurant;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public class ReservationDTO {
    private Long reservationID;
    private String userEmail;
    private BigDecimal rating;
    private Long tableNumber;
    private LocalDateTime reservationDateTime;
    private LocalDateTime checkInTime;
    private Long restaurantId;
    private int partySize;
    private String status;
    private String specialRequests;
    private String paymentStatus;
    private List<PreorderedItem> preOrderedItems;

    public ReservationDTO() {
    }

    public ReservationDTO(Long reservationID, String userEmail, BigDecimal rating, Long tableNumber, LocalDateTime reservationDateTime, LocalDateTime checkInTime, Long restaurantId, int partySize, String status, String specialRequests, String paymentStatus, List<PreorderedItem> preOrderedItems) {
        this.reservationID = reservationID;
        this.userEmail = userEmail;
        this.rating = rating;
        this.tableNumber = tableNumber;
        this.reservationDateTime = reservationDateTime;
        this.checkInTime = checkInTime;
        this.reservationID = restaurantId;
        this.partySize = partySize;
        this.status = status;
        this.specialRequests = specialRequests;
        this.paymentStatus = paymentStatus;
        this.preOrderedItems = preOrderedItems;
    }

    public ReservationDTO(Reservation reservation) {
        this.reservationID = reservation.getReservationID();
        this.userEmail = reservation.getUser().getEmail();
        this.rating = reservation.getRestaurant().getRating();
        this.tableNumber = reservation.getTable().getId();
        this.reservationDateTime = reservation.getReservationDateTime();
        this.checkInTime = reservation.getCheckInTime();
        this.restaurantId = reservation.getRestaurant().getRestaurantId();
        this.partySize = reservation.getPartySize();
        this.status = reservation.getStatus();
        this.specialRequests = reservation.getSpecialRequests();
        this.paymentStatus = reservation.getPaymentStatus();
        this.preOrderedItems = reservation.getPreOrderedItems();
    }

    public Long getReservationID() {
        return reservationID;
    }

    public void setReservationID(Long reservationID) {
        this.reservationID = reservationID;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public BigDecimal getRating() {
        return rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public Long getTableNumber() {
        return tableNumber;
    }

    public void setTableNumber(Long tableNumber) {
        this.tableNumber = tableNumber;
    }

    public LocalDateTime getReservationDateTime() {
        return reservationDateTime;
    }

    public void setReservationDateTime(LocalDateTime reservationDateTime) {
        this.reservationDateTime = reservationDateTime;
    }

    public LocalDateTime getCheckInTime() {
        return checkInTime;
    }

    public void setCheckInTime(LocalDateTime checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(Long restaurantId) {
        this.restaurantId = restaurantId;
    }

    public int getPartySize() {
        return partySize;
    }

    public void setPartySize(int partySize) {
        this.partySize = partySize;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSpecialRequests() {
        return specialRequests;
    }

    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public List<PreorderedItem> getPreOrderedItems() {
        return preOrderedItems;
    }

    public void setPreOrderedItems(List<PreorderedItem> preOrderedItems) {
        this.preOrderedItems = preOrderedItems;
    }
}
