package com.example.rezevirajmasa.demo.service;

import com.example.rezevirajmasa.demo.dto.ReservationDTO;
import com.example.rezevirajmasa.demo.dto.RestaurantDTO;
import com.example.rezevirajmasa.demo.model.*;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.userdetails.UserDetails;

import java.time.LocalDateTime;
import java.util.List;

public interface ReservationService {
    public Reservation makeReservationRest(ReservationDTO reservation, User user, Restaurant restaurant);
    public List<Reservation> listAll();
    public Reservation updateReservation(Long reservationId, ReservationDTO reservationDTO, User user);
    public List<Reservation> reservationsForTable(TableEntity table);
    public Reservation findById(Long id);
    public Reservation getReservationById(Long reservationId);
    public boolean cancelReservation(Long reservationId);
    public List<Reservation> findReservationByUser(User user);
    public List<Reservation> findAllByUser(User user);
    public List<Reservation> findReservationsByUserPast(User user);
    public List<Reservation> findReservationsByTableAndDateRange(TableEntity table, LocalDateTime startDateTime, LocalDateTime endDateTime);
    @Scheduled(cron = "0 0 0 * * ?")
    void findReservationsToMove();
    void deleteReservation(Long reservationID);

    List<Reservation> findAllByRestaurant(Restaurant restaurant);
}
