package com.example.rezevirajmasa.demo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "menus")
@Data
public class Menu {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "menu_id")
    private Long menuID;

    @ManyToOne
    @JoinColumn(name = "restaurant_id", nullable = false)
    @JsonIgnore
    private Restaurant restaurant;

    @Column(name = "item_name", length = 100)
    private String itemName;

    @Column(name = "category", length = 50)
    private String category;

    @Column(name = "price", precision = 8, scale = 2)
    private BigDecimal price;

    @Column(name = "description")
    private String description;

    @OneToMany(mappedBy = "menu", cascade = CascadeType.ALL, orphanRemoval = true, fetch = FetchType.LAZY)
    private List<MenuTag> tags = new ArrayList<>();

    public Menu() {
    }

    public Menu(Long menuID, Restaurant restaurant, String itemName, String category, BigDecimal price, String description, List<MenuTag> tags) {
        this.menuID = menuID;
        this.restaurant = restaurant;
        this.itemName = itemName;
        this.category = category;
        this.price = price;
        this.description = description;
        this.tags = tags;
    }
}