package com.example.rezevirajmasa.demo.web.rest;

import com.example.rezevirajmasa.demo.model.Customer;
import com.example.rezevirajmasa.demo.service.CustomerService;
import org.apache.coyote.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins = "http://localhost:3000/")
@RestController
public class AuthController {
    private final CustomerService customerService;
    private final PasswordEncoder passwordEncoder;

    public AuthController(CustomerService customerService, PasswordEncoder passwordEncoder) {
        this.customerService = customerService;
        this.passwordEncoder = passwordEncoder;
    }

    @PostMapping("/api/login")
    public ResponseEntity<String> login(@RequestBody Customer customer) {
        Customer exisitngCustomer = customerService.findByEmail(customer.getEmail());

        if(passwordEncoder.matches(customer.getPassword(), exisitngCustomer.getPassword())) {
            String token = generateToken(exisitngCustomer);
            return ResponseEntity.ok(token);
        } else {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build();
        }
    }

    private String generateToken(Customer customer) {
        // Implement your token generation logic here
        return "dummy_token";
    }
}
