package com.example.rezevirajmasa.demo.mappers;

import com.example.rezevirajmasa.demo.dto.SignUpDto;
import com.example.rezevirajmasa.demo.dto.UserDto;
import com.example.rezevirajmasa.demo.model.User;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserDto toUserDto(User user) {
        if (user == null) {
            return null;
        }

        UserDto userDto = new UserDto();
        userDto.setId(user.getId());
        userDto.setFirstName(user.getFirstName());
        userDto.setLastName(user.getLastName());
        userDto.setEmail(user.getEmail());

        return userDto;
    }

    @Override
    public User signUpToUser(SignUpDto userDto) {
        if (userDto == null) {
            return null;
        }

        User user = new User();
        user.setEmail(userDto.getEmail());
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setPassword(Arrays.toString(userDto.getPassword()));

        return user;
    }
}
